/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.runtime.util;

import java.util.Collection;
import java.util.concurrent.locks.ReentrantLock;

public abstract class SynchronizedPool<T> {
    private final ReentrantLock lock = new ReentrantLock();
    private final T[] pool;
    private final int capacity;
    private int size;

    public SynchronizedPool(int capacity) {
        this.capacity = capacity;
        this.pool = new Object[capacity];
        this.size = 0;
    }

    public T poll() {
        this.lock.lock();
        try {
            if (this.size == 0) {
                T t = null;
                return t;
            }
            T t = this.pool[--this.size];
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public abstract void reset(T var1);

    public abstract T pollOrCreate();

    public boolean offer(T obj) {
        this.lock.lock();
        try {
            if (this.size >= this.capacity) {
                boolean bl = false;
                return bl;
            }
            this.reset(obj);
            this.pool[this.size++] = obj;
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int offerAll(Collection<T> objs) {
        this.lock.lock();
        try {
            int count = 0;
            int remaining = this.capacity - this.size;
            for (T obj : objs) {
                if (count >= remaining) break;
                this.reset(obj);
                this.pool[this.size++] = obj;
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            this.size = 0;
        }
        finally {
            this.lock.unlock();
        }
    }
}

