/*
 * Decompiled with CFR 0.152.
 */
package com.badoo.reaktive.subject.unicast;

import com.badoo.reaktive.disposable.SerialDisposable;
import com.badoo.reaktive.observable.ObservableObserver;
import com.badoo.reaktive.subject.AbstractSubject;
import com.badoo.reaktive.subject.LinkedQueue;
import com.badoo.reaktive.subject.LinkedQueueExtKt;
import com.badoo.reaktive.subject.Subject;
import com.badoo.reaktive.subject.SubjectExtKt;
import com.badoo.reaktive.subject.unicast.UnicastSubject;
import com.badoo.reaktive.utils.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0016\u0012\u0004\u0012\u0002H\u0001\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u001b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ&\u0010\u000e\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0003H\u0014J\u0016\u0010\u0012\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0014J\u0015\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0016\u0010\u0019\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0016R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/badoo/reaktive/subject/unicast/UnicastSubjectImpl;", "T", "Lcom/badoo/reaktive/subject/AbstractSubject;", "Lcom/badoo/reaktive/subject/LinkedQueue$Node;", "Lcom/badoo/reaktive/subject/unicast/UnicastSubject;", "bufferLimit", "", "onTerminate", "Lkotlin/Function0;", "", "(ILkotlin/jvm/functions/Function0;)V", "buffer", "Lcom/badoo/reaktive/utils/atomic/AtomicReference;", "Lcom/badoo/reaktive/subject/LinkedQueue;", "onAfterSubscribe", "observer", "Lcom/badoo/reaktive/observable/ObservableObserver;", "token", "onAfterUnsubscribe", "onBeforeNext", "value", "(Ljava/lang/Object;)V", "onStatusChanged", "status", "Lcom/badoo/reaktive/subject/Subject$Status;", "subscribe", "reaktive_debug"})
public final class UnicastSubjectImpl<T>
extends AbstractSubject<T, LinkedQueue.Node<? extends T>>
implements UnicastSubject<T> {
    @NotNull
    private final Function0<Unit> onTerminate;
    @NotNull
    private final AtomicReference<LinkedQueue<T>> buffer;

    public UnicastSubjectImpl(int bufferLimit, @NotNull Function0<Unit> onTerminate) {
        Intrinsics.checkNotNullParameter(onTerminate, (String)"onTerminate");
        this.onTerminate = onTerminate;
        this.buffer = new AtomicReference(new LinkedQueue(bufferLimit));
    }

    @Override
    public void subscribe(@NotNull ObservableObserver<? super T> observer2) {
        Intrinsics.checkNotNullParameter(observer2, (String)"observer");
        SerialDisposable serialDisposable = this.onSubscribe(observer2);
        if (serialDisposable == null) {
            return;
        }
        SerialDisposable disposable = serialDisposable;
        LinkedQueue buffer2 = (LinkedQueue)this.buffer.getAndSet(null);
        if (buffer2 != null) {
            LinkedQueue.Node node = buffer2.getHead();
            LinkedQueue.Node lastNode2 = node != null ? LinkedQueueExtKt.forEachAndGetLast(node, (Function1)new Function1<T, Unit>(observer2){
                final /* synthetic */ ObservableObserver<T> $observer;
                {
                    this.$observer = $observer;
                    super(1);
                }

                public final void invoke(T it) {
                    this.$observer.onNext(it);
                }
            }) : null;
            this.onSubscribe(observer2, disposable, lastNode2);
        } else {
            observer2.onError(new IllegalStateException("Only one single observer allowed for UnicastSubject"));
        }
    }

    @Override
    protected void onAfterSubscribe(@NotNull ObservableObserver<? super T> observer2, @Nullable LinkedQueue.Node<? extends T> token) {
        block0: {
            Intrinsics.checkNotNullParameter(observer2, (String)"observer");
            super.onAfterSubscribe(observer2, token);
            LinkedQueue.Node<T> node = token;
            if (node == null || (node = node.getNext()) == null) break block0;
            LinkedQueueExtKt.forEachAndGetLast(node, (Function1)new Function1<T, Unit>(observer2){
                final /* synthetic */ ObservableObserver<T> $observer;
                {
                    this.$observer = $observer;
                    super(1);
                }

                public final void invoke(T it) {
                    this.$observer.onNext(it);
                }
            });
        }
    }

    @Override
    protected void onBeforeNext(T value) {
        block0: {
            super.onBeforeNext(value);
            LinkedQueue linkedQueue = (LinkedQueue)this.buffer.getValue();
            if (linkedQueue == null) break block0;
            linkedQueue.addLast(value);
        }
    }

    @Override
    protected void onAfterUnsubscribe(@NotNull ObservableObserver<? super T> observer2) {
        Intrinsics.checkNotNullParameter(observer2, (String)"observer");
        super.onAfterUnsubscribe(observer2);
        if (SubjectExtKt.isActive(this)) {
            this.setStatus(Subject.Status.Completed.INSTANCE);
        }
    }

    @Override
    protected void onStatusChanged(@NotNull Subject.Status status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        super.onStatusChanged(status);
        if (!SubjectExtKt.isActive(this)) {
            this.onTerminate.invoke();
        }
    }
}

