/*
 * Decompiled with CFR 0.152.
 */
package com.badoo.reaktive.utils;

import com.badoo.reaktive.utils.EnhancedDelayQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0001\u0013B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u000b\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u0005J\u001b\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/badoo/reaktive/utils/ExpirationPool;", "T", "", "onItemExpired", "Lkotlin/Function1;", "", "(Lkotlin/jvm/functions/Function1;)V", "daemon", "Lcom/badoo/reaktive/utils/ExpirationPool$Daemon;", "queue", "Lcom/badoo/reaktive/utils/EnhancedDelayQueue;", "acquire", "()Ljava/lang/Object;", "destroy", "release", "item", "timeoutMillis", "", "(Ljava/lang/Object;J)V", "Daemon", "reaktive_debug"})
public final class ExpirationPool<T> {
    @NotNull
    private final EnhancedDelayQueue<T> queue;
    @NotNull
    private final Daemon<T> daemon;

    public ExpirationPool(@NotNull Function1<? super T, Unit> onItemExpired) {
        Intrinsics.checkNotNullParameter(onItemExpired, (String)"onItemExpired");
        this.queue = new EnhancedDelayQueue();
        this.daemon = new Daemon<T>(this.queue, onItemExpired);
        this.daemon.start();
    }

    @Nullable
    public final T acquire() {
        return this.queue.removeFirst();
    }

    public final void release(@NotNull T item, long timeoutMillis) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        this.queue.offer(item, timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public final void destroy() {
        this.daemon.interrupt();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B'\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\bH\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/badoo/reaktive/utils/ExpirationPool$Daemon;", "T", "", "Ljava/lang/Thread;", "queue", "Lcom/badoo/reaktive/utils/EnhancedDelayQueue;", "onItemExpired", "Lkotlin/Function1;", "", "(Lcom/badoo/reaktive/utils/EnhancedDelayQueue;Lkotlin/jvm/functions/Function1;)V", "run", "reaktive_debug"})
    private static final class Daemon<T>
    extends Thread {
        @NotNull
        private final EnhancedDelayQueue<T> queue;
        @NotNull
        private final Function1<T, Unit> onItemExpired;

        public Daemon(@NotNull EnhancedDelayQueue<T> queue2, @NotNull Function1<? super T, Unit> onItemExpired) {
            Intrinsics.checkNotNullParameter(queue2, (String)"queue");
            Intrinsics.checkNotNullParameter(onItemExpired, (String)"onItemExpired");
            this.queue = queue2;
            this.onItemExpired = onItemExpired;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            super.run();
            while (!this.isInterrupted()) {
                try {
                    T t = this.queue.take();
                    this.onItemExpired.invoke(t);
                }
                catch (InterruptedException e) {
                    this.interrupt();
                    break;
                }
            }
        }
    }
}

