/*
 * Decompiled with CFR 0.152.
 */
package com.badoo.reaktive.utils;

import com.badoo.reaktive.base.exceptions.CompositeException;
import com.badoo.reaktive.utils.PrintError;
import com.badoo.reaktive.utils.UncaughtErrorHandlerKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0005H\u0002\u001a&\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0005\u001a \u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u00a8\u0006\f"}, d2={"handleError", "", "error", "", "onError", "Lkotlin/Function1;", "handleReaktiveError", "printErrors", "message", "", "outerError", "innerError", "reaktive_debug"})
public final class HandleSourceErrorKt {
    public static final void handleReaktiveError(@NotNull Throwable error, @Nullable Function1<? super Throwable, Unit> onError2) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (onError2 == null) {
            HandleSourceErrorKt.handleError(error);
        } else {
            HandleSourceErrorKt.handleError(error, onError2);
        }
    }

    public static /* synthetic */ void handleReaktiveError$default(Throwable throwable, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        HandleSourceErrorKt.handleReaktiveError(throwable, (Function1<? super Throwable, Unit>)function1);
    }

    private static final void handleError(Throwable error) {
        try {
            UncaughtErrorHandlerKt.getReaktiveUncaughtErrorHandler().invoke((Object)error);
        }
        catch (Throwable errorDeliveryException) {
            HandleSourceErrorKt.printErrors("Error delivering uncaught error", error, errorDeliveryException);
        }
    }

    private static final void handleError(Throwable error, Function1<? super Throwable, Unit> onError2) {
        try {
            onError2.invoke((Object)error);
        }
        catch (Throwable errorHandlerException) {
            HandleSourceErrorKt.printErrors("onError callback failed", error, errorHandlerException);
            try {
                UncaughtErrorHandlerKt.getReaktiveUncaughtErrorHandler().invoke((Object)new CompositeException(error, errorHandlerException));
            }
            catch (Throwable errorDeliveryException) {
                HandleSourceErrorKt.printErrors("Error delivering uncaught error", error, errorDeliveryException);
            }
        }
    }

    private static final void printErrors(String message, Throwable outerError, Throwable innerError) {
        PrintError.printError(message + " (" + outerError + "): " + innerError);
        outerError.printStackTrace();
        innerError.printStackTrace();
    }
}

