/*
 * Decompiled with CFR 0.152.
 */
package com.badoo.reaktive.observable;

import com.badoo.reaktive.base.ErrorCallback;
import com.badoo.reaktive.base.Observer;
import com.badoo.reaktive.completable.Completable;
import com.badoo.reaktive.completable.CompletableObserver;
import com.badoo.reaktive.disposable.CompositeDisposable;
import com.badoo.reaktive.disposable.CompositeDisposableExtKt;
import com.badoo.reaktive.disposable.Disposable;
import com.badoo.reaktive.disposable.SerialDisposable;
import com.badoo.reaktive.observable.Observable;
import com.badoo.reaktive.observable.ObservableEmitter;
import com.badoo.reaktive.observable.ObservableObserver;
import com.badoo.reaktive.utils.Uninitialized;
import com.badoo.reaktive.utils.serializer.DefaultSerializer;
import com.badoo.reaktive.utils.serializer.Serializer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\t\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0004!\"#$B?\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010\u0014\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0002J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\tH\u0002J\b\u0010\u0019\u001a\u00020\tH\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0015\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0015\u0010 \u001a\u00020\t2\u0006\u0010\u001e\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001fR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/badoo/reaktive/observable/ThrottleLatest;", "T", "", "upstream", "Lcom/badoo/reaktive/observable/Observable;", "timeoutSupplier", "Lkotlin/Function1;", "Lcom/badoo/reaktive/completable/Completable;", "emitLast", "", "emitter", "Lcom/badoo/reaktive/observable/ObservableEmitter;", "<init>", "(Lcom/badoo/reaktive/observable/Observable;Lkotlin/jvm/functions/Function1;ZLcom/badoo/reaktive/observable/ObservableEmitter;)V", "actor", "Lcom/badoo/reaktive/utils/serializer/Serializer;", "lastValue", "isTimeoutActive", "timeoutObserver", "Lcom/badoo/reaktive/observable/ThrottleLatest$TimeoutObserver;", "processEvent", "event", "onEvent", "Lcom/badoo/reaktive/observable/ThrottleLatest$Event;", "onTimeout", "onUpstreamCompleted", "onError", "error", "", "onValue", "value", "(Ljava/lang/Object;)Z", "startTimeout", "Event", "AbstractObserver", "UpstreamObserver", "TimeoutObserver", "reaktive_debug"})
@SourceDebugExtension(value={"SMAP\nThrottleLatest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThrottleLatest.kt\ncom/badoo/reaktive/observable/ThrottleLatest\n+ 2 DefaultSerializer.kt\ncom/badoo/reaktive/utils/serializer/DefaultSerializerKt\n*L\n1#1,171:1\n6#2,4:172\n*S KotlinDebug\n*F\n+ 1 ThrottleLatest.kt\ncom/badoo/reaktive/observable/ThrottleLatest\n*L\n55#1:172,4\n*E\n"})
final class ThrottleLatest<T> {
    @NotNull
    private final Function1<T, Completable> timeoutSupplier;
    private final boolean emitLast;
    @NotNull
    private final ObservableEmitter<T> emitter;
    @NotNull
    private final Serializer<Object> actor;
    @Nullable
    private Object lastValue;
    private boolean isTimeoutActive;
    @NotNull
    private final TimeoutObserver timeoutObserver;

    public ThrottleLatest(@NotNull Observable<? extends T> upstream, @NotNull Function1<? super T, ? extends Completable> timeoutSupplier, boolean emitLast, @NotNull ObservableEmitter<? super T> emitter) {
        Intrinsics.checkNotNullParameter(upstream, (String)"upstream");
        Intrinsics.checkNotNullParameter(timeoutSupplier, (String)"timeoutSupplier");
        Intrinsics.checkNotNullParameter(emitter, (String)"emitter");
        this.timeoutSupplier = timeoutSupplier;
        this.emitLast = emitLast;
        this.emitter = emitter;
        boolean $i$f$serializer = false;
        this.actor = new DefaultSerializer<Object>(this){
            final /* synthetic */ ThrottleLatest $receiver$inlined;
            {
                this.$receiver$inlined = throttleLatest;
            }

            protected boolean onValue(Object value) {
                Object p0 = value;
                boolean bl = false;
                return ThrottleLatest.access$processEvent(this.$receiver$inlined, p0);
            }
        };
        this.lastValue = Uninitialized.INSTANCE;
        this.timeoutObserver = new TimeoutObserver(this.actor);
        CompositeDisposable disposables = new CompositeDisposable();
        this.emitter.setDisposable(disposables);
        UpstreamObserver upstreamObserver2 = new UpstreamObserver(this.actor);
        CompositeDisposableExtKt.plusAssign(disposables, upstreamObserver2);
        CompositeDisposableExtKt.plusAssign(disposables, this.timeoutObserver);
        upstream.subscribe(upstreamObserver2);
    }

    private final boolean processEvent(Object event) {
        return event instanceof Event ? this.onEvent((Event)event) : this.onValue(event);
    }

    private final boolean onEvent(Event event) {
        boolean bl;
        Event event2 = event;
        if (Intrinsics.areEqual((Object)event2, (Object)Event.Timeout.INSTANCE)) {
            bl = this.onTimeout();
        } else if (Intrinsics.areEqual((Object)event2, (Object)Event.UpstreamCompleted.INSTANCE)) {
            bl = this.onUpstreamCompleted();
        } else if (event2 instanceof Event.Error) {
            bl = this.onError(((Event.Error)event).getError());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private final boolean onTimeout() {
        Object value = this.lastValue;
        this.lastValue = Uninitialized.INSTANCE;
        this.isTimeoutActive = false;
        return value == Uninitialized.INSTANCE || this.startTimeout(value);
    }

    private final boolean onUpstreamCompleted() {
        Object value = this.lastValue;
        this.lastValue = Uninitialized.INSTANCE;
        if (this.emitLast && value != Uninitialized.INSTANCE) {
            this.emitter.onNext(value);
        }
        this.emitter.onComplete();
        return false;
    }

    private final boolean onError(Throwable error) {
        this.emitter.onError(error);
        return false;
    }

    private final boolean onValue(T value) {
        boolean bl;
        if (this.isTimeoutActive) {
            this.lastValue = value;
            bl = true;
        } else {
            bl = this.startTimeout(value);
        }
        return bl;
    }

    private final boolean startTimeout(T value) {
        this.isTimeoutActive = true;
        this.emitter.onNext(value);
        try {
            ((Completable)this.timeoutSupplier.invoke(value)).subscribe((Observer)this.timeoutObserver);
        }
        catch (Throwable e) {
            this.onError(e);
            return false;
        }
        return true;
    }

    public static final /* synthetic */ boolean access$processEvent(ThrottleLatest $this, Object event) {
        return $this.processEvent(event);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0012\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/badoo/reaktive/observable/ThrottleLatest$AbstractObserver;", "Lcom/badoo/reaktive/base/Observer;", "Lcom/badoo/reaktive/base/ErrorCallback;", "Lcom/badoo/reaktive/disposable/SerialDisposable;", "actor", "Lcom/badoo/reaktive/utils/serializer/Serializer;", "", "<init>", "(Lcom/badoo/reaktive/utils/serializer/Serializer;)V", "onSubscribe", "", "disposable", "Lcom/badoo/reaktive/disposable/Disposable;", "onError", "error", "", "reaktive_debug"})
    private static class AbstractObserver
    extends SerialDisposable
    implements Observer,
    ErrorCallback {
        @NotNull
        private final Serializer<Object> actor;

        public AbstractObserver(@NotNull Serializer<Object> actor) {
            Intrinsics.checkNotNullParameter(actor, (String)"actor");
            this.actor = actor;
        }

        @Override
        public void onSubscribe(@NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            this.set(disposable);
        }

        @Override
        public void onError(@NotNull Throwable error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            this.actor.accept(new Event.Error(error));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lcom/badoo/reaktive/observable/ThrottleLatest$Event;", "", "<init>", "()V", "Timeout", "UpstreamCompleted", "Error", "Lcom/badoo/reaktive/observable/ThrottleLatest$Event$Error;", "Lcom/badoo/reaktive/observable/ThrottleLatest$Event$Timeout;", "Lcom/badoo/reaktive/observable/ThrottleLatest$Event$UpstreamCompleted;", "reaktive_debug"})
    private static abstract class Event {
        private Event() {
        }

        public /* synthetic */ Event(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/badoo/reaktive/observable/ThrottleLatest$Event$Error;", "Lcom/badoo/reaktive/observable/ThrottleLatest$Event;", "error", "", "<init>", "(Ljava/lang/Throwable;)V", "getError", "()Ljava/lang/Throwable;", "reaktive_debug"})
        public static final class Error
        extends Event {
            @NotNull
            private final Throwable error;

            public Error(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final Throwable getError() {
                return this.error;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/badoo/reaktive/observable/ThrottleLatest$Event$Timeout;", "Lcom/badoo/reaktive/observable/ThrottleLatest$Event;", "<init>", "()V", "reaktive_debug"})
        public static final class Timeout
        extends Event {
            @NotNull
            public static final Timeout INSTANCE = new Timeout();

            private Timeout() {
                super(null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/badoo/reaktive/observable/ThrottleLatest$Event$UpstreamCompleted;", "Lcom/badoo/reaktive/observable/ThrottleLatest$Event;", "<init>", "()V", "reaktive_debug"})
        public static final class UpstreamCompleted
        extends Event {
            @NotNull
            public static final UpstreamCompleted INSTANCE = new UpstreamCompleted();

            private UpstreamCompleted() {
                super(null);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/badoo/reaktive/observable/ThrottleLatest$TimeoutObserver;", "Lcom/badoo/reaktive/completable/CompletableObserver;", "Lcom/badoo/reaktive/observable/ThrottleLatest$AbstractObserver;", "actor", "Lcom/badoo/reaktive/utils/serializer/Serializer;", "", "<init>", "(Lcom/badoo/reaktive/utils/serializer/Serializer;)V", "onComplete", "", "reaktive_debug"})
    private static final class TimeoutObserver
    extends AbstractObserver
    implements CompletableObserver {
        @NotNull
        private final Serializer<Object> actor;

        public TimeoutObserver(@NotNull Serializer<Object> actor) {
            Intrinsics.checkNotNullParameter(actor, (String)"actor");
            super(actor);
            this.actor = actor;
        }

        @Override
        public void onComplete() {
            this.actor.accept(Event.Timeout.INSTANCE);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u0017\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\nH\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/badoo/reaktive/observable/ThrottleLatest$UpstreamObserver;", "T", "Lcom/badoo/reaktive/observable/ObservableObserver;", "Lcom/badoo/reaktive/observable/ThrottleLatest$AbstractObserver;", "actor", "Lcom/badoo/reaktive/utils/serializer/Serializer;", "", "<init>", "(Lcom/badoo/reaktive/utils/serializer/Serializer;)V", "onNext", "", "value", "(Ljava/lang/Object;)V", "onComplete", "reaktive_debug"})
    private static final class UpstreamObserver<T>
    extends AbstractObserver
    implements ObservableObserver<T> {
        @NotNull
        private final Serializer<Object> actor;

        public UpstreamObserver(@NotNull Serializer<Object> actor) {
            Intrinsics.checkNotNullParameter(actor, (String)"actor");
            super(actor);
            this.actor = actor;
        }

        @Override
        public void onNext(T value) {
            this.actor.accept(value);
        }

        @Override
        public void onComplete() {
            this.actor.accept(Event.UpstreamCompleted.INSTANCE);
        }
    }
}

