/*
 * Decompiled with CFR 0.152.
 */
package com.badoo.reaktive.observable;

import com.badoo.reaktive.disposable.Disposable;
import com.badoo.reaktive.disposable.SerialDisposable;
import com.badoo.reaktive.observable.Observable;
import com.badoo.reaktive.observable.ObservableCallbacks;
import com.badoo.reaktive.observable.ObservableObserver;
import com.badoo.reaktive.subject.unicast.UnicastSubject;
import com.badoo.reaktive.subject.unicast.UnicastSubjectBuilderKt;
import com.badoo.reaktive.utils.atomic.AtomicBoolean;
import com.badoo.reaktive.utils.atomic.AtomicInt;
import com.badoo.reaktive.utils.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001!B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0015\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u0016H\u0016J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/badoo/reaktive/observable/UpstreamObserver;", "T", "Lcom/badoo/reaktive/disposable/SerialDisposable;", "Lcom/badoo/reaktive/observable/ObservableObserver;", "count", "", "skip", "activeWindowsCount", "Lcom/badoo/reaktive/utils/atomic/AtomicInt;", "downstream", "Lcom/badoo/reaktive/observable/ObservableCallbacks;", "Lcom/badoo/reaktive/observable/Observable;", "<init>", "(JJLcom/badoo/reaktive/utils/atomic/AtomicInt;Lcom/badoo/reaktive/observable/ObservableCallbacks;)V", "windows", "Lkotlin/collections/ArrayDeque;", "Lcom/badoo/reaktive/subject/unicast/UnicastSubject;", "skippedCount", "Lcom/badoo/reaktive/utils/atomic/AtomicLong;", "tailWindowValuesCount", "onWindowTerminate", "Lkotlin/Function0;", "", "onSubscribe", "disposable", "Lcom/badoo/reaktive/disposable/Disposable;", "onNext", "value", "(Ljava/lang/Object;)V", "onComplete", "onError", "error", "", "WindowWrapper", "reaktive_debug"})
@SourceDebugExtension(value={"SMAP\nWindowSized.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowSized.kt\ncom/badoo/reaktive/observable/UpstreamObserver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1863#2,2:115\n1863#2,2:117\n1863#2,2:119\n*S KotlinDebug\n*F\n+ 1 WindowSized.kt\ncom/badoo/reaktive/observable/UpstreamObserver\n*L\n75#1:115,2\n92#1:117,2\n98#1:119,2\n*E\n"})
final class UpstreamObserver<T>
extends SerialDisposable
implements ObservableObserver<T> {
    private final long count;
    private final long skip;
    @NotNull
    private final AtomicInt activeWindowsCount;
    @NotNull
    private final ObservableCallbacks<Observable<? extends T>> downstream;
    @NotNull
    private final ArrayDeque<UnicastSubject<T>> windows;
    @NotNull
    private final AtomicLong skippedCount;
    @NotNull
    private final AtomicLong tailWindowValuesCount;
    @NotNull
    private final Function0<Unit> onWindowTerminate;

    public UpstreamObserver(long count, long skip2, @NotNull AtomicInt activeWindowsCount, @NotNull ObservableCallbacks<? super Observable<? extends T>> downstream) {
        Intrinsics.checkNotNullParameter((Object)activeWindowsCount, (String)"activeWindowsCount");
        Intrinsics.checkNotNullParameter(downstream, (String)"downstream");
        this.count = count;
        this.skip = skip2;
        this.activeWindowsCount = activeWindowsCount;
        this.downstream = downstream;
        this.windows = new ArrayDeque();
        this.skippedCount = new AtomicLong(0L, 1, null);
        this.tailWindowValuesCount = new AtomicLong(0L, 1, null);
        this.onWindowTerminate = () -> UpstreamObserver.onWindowTerminate$lambda$0(this);
    }

    @Override
    public void onSubscribe(@NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.set(disposable);
    }

    @Override
    public void onNext(T value) {
        AtomicBoolean atomicBoolean;
        long l;
        long skipped = this.skippedCount.getValue();
        AtomicBoolean windowWrapper = null;
        if (skipped == 0L) {
            this.activeWindowsCount.addAndGet(1);
            UnicastSubject window = UnicastSubjectBuilderKt.UnicastSubject$default(0, this.onWindowTerminate, 1, null);
            windowWrapper = new WindowWrapper(window);
            this.windows.addLast((Object)window);
            this.downstream.onNext((Observable<AtomicBoolean>)windowWrapper);
        } else {
            windowWrapper = null;
        }
        Iterable $this$forEach$iv = (Iterable)this.windows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UnicastSubject it = (UnicastSubject)element$iv;
            boolean bl = false;
            it.onNext(value);
        }
        this.skippedCount.setValue((skipped + 1L) % this.skip);
        if (this.tailWindowValuesCount.getValue() + 1L == this.count) {
            ((UnicastSubject)this.windows.removeFirst()).onComplete();
            l = this.tailWindowValuesCount.addAndGet(1L - this.skip);
        } else {
            l = this.tailWindowValuesCount.addAndGet(1L);
        }
        boolean bl = (atomicBoolean = windowWrapper) != null && (atomicBoolean = atomicBoolean.isSubscribed()) != null ? !atomicBoolean.getValue() : false;
        if (bl) {
            windowWrapper.getWindow().onComplete();
        }
    }

    @Override
    public void onComplete() {
        Iterable $this$forEach$iv = (Iterable)this.windows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UnicastSubject it = (UnicastSubject)element$iv;
            boolean bl = false;
            it.onComplete();
        }
        this.downstream.onComplete();
        this.dispose();
    }

    @Override
    public void onError(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Iterable $this$forEach$iv = (Iterable)this.windows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UnicastSubject it = (UnicastSubject)element$iv;
            boolean bl = false;
            it.onError(error);
        }
        this.downstream.onError(error);
        this.dispose();
    }

    private static final Unit onWindowTerminate$lambda$0(UpstreamObserver this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.activeWindowsCount.addAndGet(-1) == 0) {
            this$0.dispose();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u000fH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/badoo/reaktive/observable/UpstreamObserver$WindowWrapper;", "T", "Lcom/badoo/reaktive/observable/Observable;", "window", "Lcom/badoo/reaktive/subject/unicast/UnicastSubject;", "<init>", "(Lcom/badoo/reaktive/subject/unicast/UnicastSubject;)V", "getWindow", "()Lcom/badoo/reaktive/subject/unicast/UnicastSubject;", "isSubscribed", "Lcom/badoo/reaktive/utils/atomic/AtomicBoolean;", "()Lcom/badoo/reaktive/utils/atomic/AtomicBoolean;", "subscribe", "", "observer", "Lcom/badoo/reaktive/observable/ObservableObserver;", "reaktive_debug"})
    private static final class WindowWrapper<T>
    implements Observable<T> {
        @NotNull
        private final UnicastSubject<T> window;
        @NotNull
        private final AtomicBoolean isSubscribed;

        public WindowWrapper(@NotNull UnicastSubject<T> window) {
            Intrinsics.checkNotNullParameter(window, (String)"window");
            this.window = window;
            this.isSubscribed = new AtomicBoolean(false, 1, null);
        }

        @NotNull
        public final UnicastSubject<T> getWindow() {
            return this.window;
        }

        @NotNull
        public final AtomicBoolean isSubscribed() {
            return this.isSubscribed;
        }

        @Override
        public void subscribe(@NotNull ObservableObserver<? super T> observer2) {
            Intrinsics.checkNotNullParameter(observer2, (String)"observer");
            this.isSubscribed.setValue(true);
            this.window.subscribe(observer2);
        }
    }
}

