/*
 * Copyright 2017 Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

package com.baidu.aip.machinetranslation;

import com.baidu.aip.client.BaseClient;
import com.baidu.aip.http.AipRequest;
import com.baidu.aip.http.EBodyFormat;
import com.baidu.aip.util.Base64Util;
import org.json.JSONObject;

import java.util.HashMap;

public class Machinetranslation extends BaseClient {
    
    public Machinetranslation(String appId, String apiKey, String secretKey) {
        super(appId, apiKey, secretKey);
    }

    /**
     * 文本翻译-通用版
     * 接口使用说明文档: https://ai.baidu.com/ai-doc/MT/4kqryjku9
     */
    public JSONObject texttransV1(String from, String to, String q, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        preOperation(request);

        request.addBody("from", from);
        request.addBody("to", to);
        request.addBody("q", q);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri(MachinetranslationConsts.TEXTTRANS_V1);
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        postOperation(request);
        return requestServer(request);
    }

    /**
     * 文本翻译-词典版
     * 接口使用说明文档: https://ai.baidu.com/ai-doc/MT/nkqrzmbpc
     */
    public JSONObject texttransWithDictV1(String from, String to, String q, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        preOperation(request);

        request.addBody("from", from);
        request.addBody("to", to);
        request.addBody("q", q);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri(MachinetranslationConsts.TEXTTRANS_WITH_DICT_V1);
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        postOperation(request);
        return requestServer(request);
    }

    /**
     * 文档翻译
     * 接口使用说明文档: https://ai.baidu.com/ai-doc/MT/Xky9x5xub
     */
    public JSONObject docTranslationCreateV2(String from, String to, Object input,
                                                HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        preOperation(request);

        request.addBody("from", from);
        request.addBody("to", to);
        request.addBody("input", input);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri(MachinetranslationConsts.DOC_TRANSLATION_CREATE_V2);
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        postOperation(request);
        return requestServer(request);
    }

    /**
     * 文档翻译-文档状态查询
     * 接口使用说明文档: https://ai.baidu.com/ai-doc/MT/Xky9x5xub
     */
    public JSONObject docTranslationQueryV2(String id) {
        AipRequest request = new AipRequest();
        preOperation(request);

        request.addBody("id", id);
        request.setUri(MachinetranslationConsts.DOC_TRANSLATION_QUERY_V2);
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        postOperation(request);
        return requestServer(request);
    }

    /**
     * 语音翻译
     * 接口使用说明文档: https://ai.baidu.com/ai-doc/MT/el4cmi76f
     */
    public JSONObject speechTranslationV2(String from, String to, byte[] voice, String format,
                                            HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        preOperation(request);

        request.addBody("from", from);
        request.addBody("to", to);
        request.addBody("voice", Base64Util.encode(voice));
        request.addBody("format", format);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri(MachinetranslationConsts.SPEECH_TRANSLATION_V2);
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        postOperation(request);
        return requestServer(request);
    }

}
