/*
 * Copyright (C) 2016 Baidu, Inc. All Rights Reserved.
 */
package com.baidu.driver4j.bdrp.bns;

import java.util.Map;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * bdrp的bns的配置对象
 * Created by chenxingbo on 2016/7/13.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class BnsGroupConf {

    //作智能地域，客户端需要根据idc_map进行智能地域的选择。
    @JsonProperty("idc_map")
    private Map<String, IdcMapInfo> idcMap;
    //连接超时，单位为ms
    @JsonProperty("service_ctimeout")
    private Integer serviceCtimeout;
    //读超时，单位为ms
    @JsonProperty("service_rtimeout")
    private Integer serviceRtimeout;
    //写超时，单位为ms
    @JsonProperty("service_wtimeout")
    private Integer serviceWtimeout;
    //请求失败重试次数
    @JsonProperty("service_retry")
    private Integer serviceRetry;
    //均衡：SuperStrategy->Balance为均衡策略，只需支持两种即可：Random(随机)、RoundRobin(轮询)。
    @JsonProperty("SuperStrategy")
    private Map<String, String> superStrategy;

    public Map<String, IdcMapInfo> getIdcMap() {
        return idcMap;
    }

    public void setIdcMap(Map<String, IdcMapInfo> idcMap) {
        this.idcMap = idcMap;
    }

    public Integer getServiceCtimeout() {
        return serviceCtimeout;
    }

    public Integer getServiceRtimeout() {
        return serviceRtimeout;
    }

    public Integer getServiceWtimeout() {
        return serviceWtimeout;
    }

    public Integer getServiceRetry() {
        return serviceRetry;
    }

    public Map<String, String> getSuperStrategy() {
        return superStrategy;
    }

    public void setSuperStrategy(Map<String, String> superStrategy) {
        this.superStrategy = superStrategy;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class IdcMapInfo {
        //优先选择的配置
        private Set<String> prefer;
        //备选配置(在)
        private Set<String> backup;

        public Set<String> getBackup() {
            return backup;
        }

        public void setBackup(Set<String> backup) {
            this.backup = backup;
        }

        public Set<String> getPrefer() {
            return prefer;
        }

        public void setPrefer(Set<String> prefer) {
            this.prefer = prefer;
        }
    }
}
