/*
 * Copyright (C) 2016 Baidu, Inc. All Rights Reserved.
 */
package com.baidu.driver4j.bdrp.bns;

import com.baidu.driver4j.bns.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Bns的类型鉴别的帮助类，用来区分是否是group或者service
 * Created by chenxingbo on 2016/9/28.
 */
public class BnsHelper {
    private static final Logger logger = LoggerFactory.getLogger(BnsHelper.class);
    protected static String bnsServer = "http://bns.noah.baidu.com/webfoot/index.php";
    private static BNSQueryProxy bnsQueryProxy = getBnsQueryProxy();

    static BNSQueryProxy getBnsQueryProxy() {
        bnsQueryProxy = BNSQueryProxy.proxy(bnsServer);
        bnsQueryProxy.setConnectTimeout(10000);
        bnsQueryProxy.setReadTimeout(10000);
        return bnsQueryProxy;
    }

    /**
     * 是否是bns组
     */
    public static boolean isBnsGroup(String name) {
        try {
            Group group = bnsQueryProxy.getServiceGroup(name);
            if (group != null) {
                return true;
            }
        } catch (Exception e) {
            logger.error("isBnsGroup occur exception ", e);
        }
        return false;
    }

    /**
     * 是否是bns service
     */
    public static boolean isBnsService(String name) {
        Service service = bnsQueryProxy.getService(name);
        return service != null;
    }

    public static List<Instance> queryValidInstances(BNSQueryAgentProxy bnsQueryAgentProxy, String serviceName) throws BNSException {
        List<Instance> instances = null;
        try {
            instances = bnsQueryAgentProxy.getInstanceByService(serviceName);
        } catch (Exception e) {
            logger.info("bnsQueryAgentProxy.getInstanceByService() fail,retry to use bnsQueryProxy.getInstances()");
            instances = bnsQueryAgentProxy.getBnsQueryProxy().getInstances(serviceName, 0);
        }
        return getValidInstances(instances);
    }


    private static List<Instance> getValidInstances(List<Instance> instances) {
        if (CollectionUtils.isEmpty(instances)) {
            return null;
        }
        List<Instance> result = new ArrayList<Instance>();
        for (Instance instance : instances) {
            if (instance != null && instance.getStatus() == 0 && (!instance.isDisable())) {
                result.add(instance);
            }
        }
        return result;
    }

}
