/*
 * Copyright (C) 2015 Baidu, Inc. All Rights Reserved.
 */
package com.baidu.driver4j.bdrp.client;

import redis.clients.jedis.AdvancedBinaryJedisCommands;
import redis.clients.jedis.AdvancedJedisCommands;
import redis.clients.jedis.BasicCommands;
import redis.clients.jedis.BinaryJedisCommands;
import redis.clients.jedis.BinaryScriptingCommands;
import redis.clients.jedis.ClusterCommands;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.MultiKeyBinaryCommands;
import redis.clients.jedis.MultiKeyCommands;
import redis.clients.jedis.ScriptingCommands;

/**
 * BDRP客户端接口，主要是把Jedis所实现的接口都继承了
 *
 * @author dingxuefeng
 */
public interface BdrpClient
        extends BasicCommands, BinaryJedisCommands, MultiKeyBinaryCommands, AdvancedBinaryJedisCommands,
        BinaryScriptingCommands, JedisCommands, MultiKeyCommands, AdvancedJedisCommands, ScriptingCommands,
        ClusterCommands {

    /**
     * 从连接池中取出一个Jedis实例。
     * 切记用完要放回去！！！
     *
     * @return 池中的实例
     */
    Jedis getJedisFromPool();

    /**
     * 将Jedis放回池中，需要在方法中判断连接是否可用
     * 这里只放了一个return，避免使用者忘记区分是否出问题
     *
     * @param jedis 待归还的Jedis
     */
    void returnJedisToPool(Jedis jedis);
}
