/*
 * Copyright (C) 2016 Baidu, Inc. All Rights Reserved.
 */
package com.baidu.driver4j.bdrp.client;

import org.springframework.util.Assert;

import com.baidu.driver4j.bdrp.node.NodeManager;

/**
 * 根据参数构建BdrpClient的工具类
 * Created by chenxingbo on 2016/7/27.
 */
public class BdrpClientBuildHelper {
    /**
     * 获取指定nodeManager的bdrp client
     */
    public static BdrpClient getBdrpClient(NodeManager nodeManager) {
        Assert.notNull(nodeManager, "nodeManager can not be null!");
        return getBdrpClientByBdrpClientFactory(null, null, nodeManager);
    }

    /**
     * 获取指定nodes的bdrp client
     */
    public static BdrpClient getBdrpClient(String nodes) {
        Assert.hasText(nodes, "nodes can not be empty !");
        return getBdrpClientByBdrpClientFactory(nodes, null, null);
    }

    /**
     * 获取指定nodes的bdrp client
     */
    public static BdrpClient getBdrpClient(String groupNodes, String idc) {
        Assert.hasText(groupNodes, "nodes can not be empty !");
        return getBdrpClientByBdrpClientFactory(groupNodes, idc, null);
    }

    private static BdrpClient getBdrpClientByBdrpClientFactory(String nodes, String idc, NodeManager nodeManager) {
        BdrpClientFactory factory = new BdrpClientFactory();
        factory.setNodeManager(nodeManager);
        factory.setIdc(idc);
        factory.setNodes(nodes);
        factory.init();
        return factory.getBdrpClient();
    }
}
