/*
 * Copyright (C) 2015 Baidu, Inc. All Rights Reserved.
 */

package com.baidu.driver4j.bdrp.node;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.baidu.driver4j.bdrp.node.health.HealthCriteria;

import redis.clients.jedis.Jedis;

/**
 * BDRP客户端的各种辅助方法
 *
 * @author dingxuefeng
 */
public class BdrpUtils {
    private static final Logger logger = LoggerFactory.getLogger(BdrpUtils.class);

    /**
     * 验证Jedis是否可用
     */
    public static boolean validateJedis(Jedis jedis) {
        if (jedis == null) {
            return false;
        }
        try {
            boolean flag = jedis.isConnected();
            if (!flag) {
                try {
                    jedis.get(HealthCriteria.TEST_KEY.getBytes());
                } catch (Exception e) {
                    flag = false;
                    logger.warn(String.format("Exception occurred while validating BDRP node %s:%s", jedis.getClient().getHost(), jedis.getClient().getPort()), e);
                }
            }
            return flag;
        } catch (Exception e) {
            logger.warn(String.format("Exception occurred while validating BDRP node %s:%s", jedis.getClient().getHost(), jedis.getClient().getPort()), e);
            return false;
        }
    }
}
