/*
 * Copyright (C) 2016 Baidu, Inc. All Rights Reserved.
 */
package com.baidu.driver4j.bdrp.node;

import com.baidu.driver4j.bdrp.bns.BnsGroupConfUpdater;
import com.baidu.driver4j.bdrp.bns.BnsHelper;
import com.baidu.driver4j.bdrp.bns.GroupIDCInstanceQuery;
import com.baidu.driver4j.bns.BNSCallbackProxy;
import com.baidu.driver4j.bns.BNSException;
import com.baidu.driver4j.bns.Instance;
import com.baidu.driver4j.bns.InstanceQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * A BNS Group supports class for {@link NodeManager} which provide BNS change
 * callback feature.
 *
 * @author chenxingbo
 */
public class BnsGroupSupportsNodeManager extends BnsSupportsNodeManager {
    private static final Logger logger = LoggerFactory.getLogger(BnsGroupSupportsNodeManager.class);
    private String idc;
    private BnsGroupConfUpdater bnsGroupConfUpdater;
    private GroupIDCInstanceQuery idcInstanceQuery;
    private int bnsGroupConfUpdateInterval = 1000;

    /**
     * 初始化BNS相关的一些配置
     */
    @Override
    public void init() {
        if (bnsGroupConfUpdater == null) {
            bnsGroupConfUpdater = new BnsGroupConfUpdater(this);
            bnsGroupConfUpdater.setBnsGroupConfUpdateInterval(bnsGroupConfUpdateInterval);
        }
        idcInstanceQuery = GroupIDCInstanceQuery.proxy(bnsServer, idc);
        idcInstanceQuery.setConnectTimeout(bnsConnectTimeout);
        idcInstanceQuery.setReadTimeout(bnsReadTimeout);
        bnsGroupConfUpdater.updateConf();
        if (bnsCallbackProxy == null) {
            bnsCallbackProxy = new BNSCallbackProxy(getBnsGroupInstanceQuery());
            bnsCallbackProxy.setInterval(bnsUpdateInterval);
        }
        super.init();
        if (enableCallback) {
            bnsGroupConfUpdater.start();
        }
    }

    @Override
    protected List<Instance> getInitedInstances() {
        return getBnsGroupInstanceQuery().queryInstances(bnsService);
    }

    public GroupIDCInstanceQuery getBnsGroupInstanceQuery() {
        return idcInstanceQuery;
    }

    @Override
    public void destroy() throws Exception {
        bnsGroupConfUpdater.stop();
        super.destroy();
    }

    public void setIdc(String idc) {
        this.idc = idc;
    }

    public void setBnsGroupConfUpdater(BnsGroupConfUpdater bnsGroupConfUpdater) {
        this.bnsGroupConfUpdater = bnsGroupConfUpdater;
    }

    public void setBnsGroupConfUpdateInterval(int bnsGroupConfUpdateInterval) {
        this.bnsGroupConfUpdateInterval = bnsGroupConfUpdateInterval;
    }
}
