/*
 * Copyright (C) 2015 Baidu, Inc. All Rights Reserved.
 */
package com.baidu.driver4j.bdrp.node.health;

import java.util.concurrent.TimeUnit;

/**
 * 健康检查使用的判断标准
 *
 * @author dingxuefeng
 */
public class HealthCriteria implements Cloneable {
    /**
     * 健康检查使用的测试键
     */
    public static final String TEST_KEY = "DO_NOT_USE_THIS_KEY_JUST_FOR_TEST_IN_BAIDU_DRIVER";

    /**
     * 连续检查失败阈值
     */
    private int checkingFailThreshold = 3;

    /**
     * 判断周期内认为节点失效的阈值
     */
    private int disableThreshold = 5;

    /**
     * 判断周期，时间单位由timeUnit决定，默认为60秒
     */
    private int period = 60;

    /**
     * 判断周期的时间单位，默认为秒
     */
    private TimeUnit timeUnit = TimeUnit.SECONDS;

    /**
     * 空构造方法
     */
    public HealthCriteria() {
    }

    /**
     * 设置失效阈值
     *
     * @param disableThreshold 阈值
     */
    public HealthCriteria(int disableThreshold) {
        this.disableThreshold = disableThreshold;
    }

    /**
     * 设置失效阈值和检查周期
     *
     * @param disableThreshold  失效阈值
     * @param period 检查周期，默认是秒
     */
    public HealthCriteria(int disableThreshold, int period) {
        this.disableThreshold = disableThreshold;
        this.period = period;
    }

    public int getDisableThreshold() {
        return disableThreshold;
    }

    public void setDisableThreshold(int disableThreshold) {
        this.disableThreshold = disableThreshold;
    }

    public int getPeriod() {
        return period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public TimeUnit getTimeUnit() {
        return timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public int getCheckingFailThreshold() {
        return checkingFailThreshold;
    }

    public void setCheckingFailThreshold(int checkingFailThreshold) {
        this.checkingFailThreshold = checkingFailThreshold;
    }
}
