/*
 * Copyright (C) 2015 Baidu, Inc. All Rights Reserved.
 */
package com.baidu.driver4j.bdrp.node.pool;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.Protocol;
import redis.clients.util.Pool;

/**
 * BDRP连接池，参考JedisPool，只要是改变了Factory
 *
 * @author dingxuefeng
 */
public class BdrpPool extends Pool<Jedis> {

    /**
     * 构造方法，不设置密码和客户端名
     *
     * @param poolConfig 连接池配置
     * @param host       主机
     * @param port       端口
     */
    public BdrpPool(GenericObjectPoolConfig poolConfig, String host, int port) {
        super(poolConfig, new BdrpFactory(host, port, Protocol.DEFAULT_TIMEOUT, null,
                Protocol.DEFAULT_DATABASE, null));
    }

    /**
     * 构造方法，不设置密码和客户端名
     *
     * @param poolConfig 连接池配置
     * @param host       主机
     * @param port       端口
     * @param timeout    超时时间
     */
    public BdrpPool(GenericObjectPoolConfig poolConfig, String host, int port, int timeout) {
        super(poolConfig, new BdrpFactory(host, port, timeout, null,
                Protocol.DEFAULT_DATABASE, null));
    }

    /**
     * 将失败的资源关闭
     *
     * @param resource Jedis资源
     */
    public void returnBrokenResource(final Jedis resource) {
        returnBrokenResourceObject(resource);
    }

    /**
     * 将正常的资源放回连接池
     *
     * @param resource Jedis资源
     */
    public void returnResource(final Jedis resource) {
        resource.resetState();
        returnResourceObject(resource);
    }
}
