/*
 * Copyright (C) 2015 Baidu, Inc. All Rights Reserved.
 */
package com.baidu.driver4j.bdrp.node.selector;

import java.util.Random;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.baidu.driver4j.bdrp.node.NodeManager;

/**
 * 随机节点选择器
 *
 * @author dingxuefeng
 */
public class RandomNodeSelector implements NodeSelector {
    private static final Logger logger = LoggerFactory.getLogger(RandomNodeSelector.class);
    private Random random = new Random();

    /**
     * 用Random随机选择一个健康节点返回
     *
     * @param nodeManager 节点管理器
     * @return 选中的节点名称
     */
    @Override
    public String selectNodeName(NodeManager nodeManager) {
        String key = null;
        Set<String> nodeSet = nodeManager.getAvailableNodes().keySet();
        if (nodeSet == null || nodeSet.isEmpty()) {
            logger.warn("Can not find available node with the given NodeManager!");
            return null;
        }

        int pos = random.nextInt(nodeSet.size());
        int idx = 0;
        for (String k : nodeSet) {
            if (idx++ >= pos) {
                key = k;
                break;
            }
        }

        logger.debug("Select a KEY: {}, {}/{}", key, pos, nodeSet.size());
        return key;
    }
}
