/*
 * Copyright (C) 2015 Baidu, Inc. All Rights Reserved.
 */
package com.baidu.driver4j.bdrp.node.selector;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.baidu.driver4j.bdrp.node.NodeManager;

/**
 * 轮询方式进行选择。 如果nodeManager返回的列表个数变化时，则轮询计数会不准确，需要一个循环后才会恢复。
 *
 * @author xiemalin
 */
public class RoundRobbinNodeSelector implements NodeSelector {
    private static final Logger logger = LoggerFactory.getLogger(RoundRobbinNodeSelector.class);
    
    private static final AtomicInteger currentPos = new AtomicInteger(-1);

    /**
     * 用Random随机选择一个健康节点返回.
     *
     * @param nodeManager 节点管理器
     * @return 选中的节点名称
     */
    @Override
    public String selectNodeName(NodeManager nodeManager) {
        String key = null;
        Set<String> nodeSet = nodeManager.getAvailableNodes().keySet();
        if (nodeSet == null || nodeSet.isEmpty()) {
            logger.warn("Can not find available node with the given NodeManager!");
            return null;
        }
        
        currentPos.set(currentPos.incrementAndGet() % nodeSet.size());
        int pos = currentPos.get();
        int idx = 0;
        for (String k : nodeSet) {
            if (idx++ >= pos) {
                key = k;
                break;
            }
        }

        logger.debug("Select a KEY: {}, {}/{}", key, pos, nodeSet.size());
        return key;
    }
    
    /**
     * reset current position to zero;
     */
    public void reset() {
    	currentPos.set(0);
    }
}
