/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.driver4j.bdrp.bns;

import com.baidu.driver4j.bns.Group;
import com.baidu.driver4j.bns.Instance;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.CollectionUtils;

public class BdrpBnsGroup {
    private static Long VERIFICATION_TIME = 60000L;
    private Group group;
    private Map<String, List<Instance>> serviceInstances = new HashMap<String, List<Instance>>();
    private Map<String, Map.Entry<Long, List<Instance>>> verificationServiceInstances = new ConcurrentHashMap<String, Map.Entry<Long, List<Instance>>>();

    public BdrpBnsGroup(Group group, Map<String, List<Instance>> serviceInstances) {
        this.group = group;
        this.serviceInstances = serviceInstances;
    }

    public BdrpBnsGroup updateAndGet(Group group, Map<String, List<Instance>> serviceInstances) {
        BdrpBnsGroup newGroup = new BdrpBnsGroup(this.group, this.serviceInstances);
        newGroup.verificationServiceInstances = this.verificationServiceInstances;
        newGroup.update(group, serviceInstances);
        return newGroup;
    }

    private void update(Group group, Map<String, List<Instance>> serviceInstances) {
        this.group = group;
        if (this.serviceInstances == null) {
            this.serviceInstances = new HashMap<String, List<Instance>>();
        }
        this.updateServiceInstances(CollectionUtils.isEmpty(serviceInstances) ? this.serviceInstances : serviceInstances);
    }

    private void updateServiceInstances(Map<String, List<Instance>> serviceInstances) {
        HashMap<String, List<Instance>> tmpServiceInstanceMap = new HashMap<String, List<Instance>>();
        for (Map.Entry<String, List<Instance>> serviceInstanceEntry : serviceInstances.entrySet()) {
            if (this.group == null || this.group.getSerivceNames() == null || !this.group.getSerivceNames().contains(serviceInstanceEntry.getKey())) continue;
            List<Instance> originInstanceList = this.serviceInstances.get(serviceInstanceEntry.getKey());
            if (!this.needUpdateInstance(serviceInstanceEntry.getKey(), originInstanceList, serviceInstanceEntry.getValue())) continue;
            tmpServiceInstanceMap.put(serviceInstanceEntry.getKey(), serviceInstanceEntry.getValue());
        }
        this.serviceInstances = tmpServiceInstanceMap;
    }

    private boolean needUpdateInstance(String serviceName, List<Instance> originInstanceList, List<Instance> newInstanceList) {
        Map.Entry<Long, List<Instance>> verificationInstancePair;
        if (CollectionUtils.isEmpty(originInstanceList)) {
            return true;
        }
        if (newInstanceList == null) {
            newInstanceList = new ArrayList<Instance>();
        }
        if (!(originInstanceList.size() <= newInstanceList.size() * 2 || (verificationInstancePair = this.verificationServiceInstances.get(serviceName)) != null && this.objectEquals(verificationInstancePair.getValue(), newInstanceList) && System.currentTimeMillis() - verificationInstancePair.getKey() >= VERIFICATION_TIME)) {
            this.verificationServiceInstances.put(serviceName, new AbstractMap.SimpleEntry<Long, List<Instance>>(System.currentTimeMillis(), newInstanceList));
            return false;
        }
        this.verificationServiceInstances.remove(serviceName);
        return true;
    }

    private boolean objectEquals(Object var0, Object var1) {
        return var0 == null ? var1 == null : var0.equals(var1);
    }

    public Group getGroup() {
        return this.group;
    }

    public Map<String, List<Instance>> getServiceInstances() {
        return this.serviceInstances;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BdrpBnsGroup)) {
            return false;
        }
        BdrpBnsGroup that = (BdrpBnsGroup)o;
        if (!this.groupEquals(this.group, that.group)) {
            return false;
        }
        return this.serviceInstances != null ? ((Object)this.serviceInstances).equals(that.serviceInstances) : that.serviceInstances == null;
    }

    private boolean groupEquals(Group thisGroup, Group oGroup) {
        if (thisGroup == oGroup) {
            return true;
        }
        if (thisGroup.getThreshold() != oGroup.getThreshold()) {
            return false;
        }
        if (thisGroup.getThresholdPercent() != oGroup.getThresholdPercent()) {
            return false;
        }
        if (!this.objectEquals(thisGroup.getConf(), oGroup.getConf())) {
            return false;
        }
        if (!this.objectEquals(thisGroup.getName(), oGroup.getName())) {
            return false;
        }
        if (!this.objectEquals(thisGroup.getSerivceNames(), oGroup.getSerivceNames())) {
            return false;
        }
        return this.objectEquals(thisGroup.getNodePath(), oGroup.getNodePath());
    }
}

