/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.driver4j.bdrp.bns;

import com.baidu.driver4j.bdrp.bns.BnsGroupConf;
import com.baidu.driver4j.bdrp.bns.GroupIDCInstanceQuery;
import com.baidu.driver4j.bdrp.node.BnsGroupSupportsNodeManager;
import com.baidu.driver4j.bdrp.node.selector.RandomNodeSelector;
import com.baidu.driver4j.bdrp.node.selector.RoundRobbinNodeSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BnsGroupConfUpdater
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(BnsGroupConfUpdater.class);
    private Thread bnsGroupConfUpdateThread = new Thread(this);
    private int bnsGroupConfUpdateInterval = 1000;
    private volatile boolean closed = false;
    private BnsGroupSupportsNodeManager nodeManager;

    public BnsGroupConfUpdater(BnsGroupSupportsNodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.closed) {
            try {
                long timeToWait;
                long time = System.currentTimeMillis();
                boolean needForceRefesh = this.updateConf();
                if (needForceRefesh) {
                    BnsGroupSupportsNodeManager bnsGroupSupportsNodeManager = this.nodeManager;
                    synchronized (bnsGroupSupportsNodeManager) {
                        this.nodeManager.refeshNodes(null, true);
                    }
                }
                if ((timeToWait = System.currentTimeMillis() - time) >= (long)this.bnsGroupConfUpdateInterval) continue;
                try {
                    Thread.sleep((long)this.bnsGroupConfUpdateInterval - timeToWait);
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), (Object)e.getMessage(), (Object)e.getCause());
                }
            }
            catch (Exception e) {
                logger.warn("BnsGroupConfUpdater update error : {}", (Throwable)e);
            }
        }
    }

    public boolean updateConf() {
        String balanceStrategy;
        boolean needForceRefesh = false;
        GroupIDCInstanceQuery groupQueryer = this.nodeManager.getBnsGroupInstanceQuery();
        BnsGroupConf bnsGroupConf = groupQueryer.getBnsGroupConf(this.nodeManager.getBnsService());
        if (bnsGroupConf == null) {
            return false;
        }
        if (bnsGroupConf.getSuperStrategy() != null && (balanceStrategy = bnsGroupConf.getSuperStrategy().get("Balance")) != null && !"".equals(balanceStrategy.trim())) {
            if ("Random".equals(balanceStrategy) && !(this.nodeManager.getNodeSelector() instanceof RandomNodeSelector)) {
                this.nodeManager.setNodeSelector(new RandomNodeSelector());
            } else if ("RoundRobin".equals(balanceStrategy) && !(this.nodeManager.getNodeSelector() instanceof RoundRobbinNodeSelector)) {
                this.nodeManager.setNodeSelector(new RoundRobbinNodeSelector());
            }
        }
        int timeout = 0;
        if (bnsGroupConf.getServiceRtimeout() != null && bnsGroupConf.getServiceRtimeout() > timeout) {
            timeout = bnsGroupConf.getServiceRtimeout();
        }
        if (bnsGroupConf.getServiceWtimeout() != null && bnsGroupConf.getServiceWtimeout() > timeout) {
            timeout = bnsGroupConf.getServiceWtimeout();
        }
        if (timeout > 0 && timeout != this.nodeManager.getTimeout()) {
            this.nodeManager.setTimeout(timeout);
            needForceRefesh = true;
        }
        if (bnsGroupConf.getServiceRetry() != null && bnsGroupConf.getServiceRetry() >= 0) {
            this.nodeManager.setRetryCountOnError(bnsGroupConf.getServiceRetry());
        }
        return needForceRefesh;
    }

    public void stop() {
        this.closed = true;
    }

    public void start() {
        this.bnsGroupConfUpdateThread.start();
    }

    public void setBnsGroupConfUpdateInterval(int bnsGroupConfUpdateInterval) {
        this.bnsGroupConfUpdateInterval = bnsGroupConfUpdateInterval;
    }
}

