/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.driver4j.bdrp.bns;

import com.baidu.driver4j.bns.BNSException;
import com.baidu.driver4j.bns.BNSQueryAgentProxy;
import com.baidu.driver4j.bns.BNSQueryProxy;
import com.baidu.driver4j.bns.Group;
import com.baidu.driver4j.bns.Instance;
import com.baidu.driver4j.bns.Service;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class BnsHelper {
    private static final Logger logger = LoggerFactory.getLogger(BnsHelper.class);
    protected static String bnsServer = "http://bns.noah.baidu.com/webfoot/index.php";
    private static BNSQueryProxy bnsQueryProxy = BnsHelper.getBnsQueryProxy();

    static BNSQueryProxy getBnsQueryProxy() {
        bnsQueryProxy = BNSQueryProxy.proxy((String)bnsServer);
        bnsQueryProxy.setConnectTimeout(10000);
        bnsQueryProxy.setReadTimeout(10000);
        return bnsQueryProxy;
    }

    public static boolean isBnsGroup(String name) {
        try {
            Group group = bnsQueryProxy.getServiceGroup(name);
            if (group != null) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("isBnsGroup occur exception ", (Throwable)e);
        }
        return false;
    }

    public static boolean isBnsService(String name) {
        Service service = bnsQueryProxy.getService(name);
        return service != null;
    }

    public static List<Instance> queryValidInstances(BNSQueryAgentProxy bnsQueryAgentProxy, String serviceName) throws BNSException {
        List instances = null;
        try {
            instances = bnsQueryAgentProxy.getInstanceByService(serviceName);
        }
        catch (Exception e) {
            logger.info("bnsQueryAgentProxy.getInstanceByService() fail,retry to use bnsQueryProxy.getInstances()");
            instances = bnsQueryAgentProxy.getBnsQueryProxy().getInstances(serviceName, new int[]{0});
        }
        return BnsHelper.getValidInstances(instances);
    }

    private static List<Instance> getValidInstances(List<Instance> instances) {
        if (CollectionUtils.isEmpty(instances)) {
            return null;
        }
        ArrayList<Instance> result = new ArrayList<Instance>();
        for (Instance instance : instances) {
            if (instance == null || instance.getStatus() != 0 || instance.isDisable()) continue;
            result.add(instance);
        }
        return result;
    }
}

