/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.driver4j.bdrp.bns;

import com.baidu.driver4j.bdrp.bns.BdrpBnsGroup;
import com.baidu.driver4j.bdrp.bns.BnsGroupConf;
import com.baidu.driver4j.bdrp.bns.BnsHelper;
import com.baidu.driver4j.bns.BNSException;
import com.baidu.driver4j.bns.BNSQueryAgentProxy;
import com.baidu.driver4j.bns.BNSQueryProxy;
import com.baidu.driver4j.bns.Group;
import com.baidu.driver4j.bns.Instance;
import com.baidu.driver4j.bns.InstanceQuery;
import com.baidu.driver4j.bns.StringUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class GroupIDCInstanceQuery
implements InstanceQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupIDCInstanceQuery.class);
    private static final String DEFAULT_IDC = "default";
    private static final String IDC_SPERATOR = ".";
    private String idc;
    private BNSQueryAgentProxy bnsQueryAgentProxy;
    private final Map<String, BdrpBnsGroup> localGroupsCache = new ConcurrentHashMap<String, BdrpBnsGroup>();

    protected GroupIDCInstanceQuery(String bnsServerUrl, String idc) {
        BNSQueryProxy bnsQueryProxy = BNSQueryProxy.proxy((String)bnsServerUrl);
        this.bnsQueryAgentProxy = BNSQueryAgentProxy.proxy((BNSQueryProxy)bnsQueryProxy);
        this.idc = idc;
    }

    public static GroupIDCInstanceQuery proxy(String bnsServerUrl, String idc) {
        return new GroupIDCInstanceQuery(bnsServerUrl, idc);
    }

    public List<Instance> queryInstances(String bnsGroupName) throws BNSException {
        BdrpBnsGroup bdrpBnsGroup = this.localGroupsCache.get(bnsGroupName);
        BdrpBnsGroup newBdrpBnsGroup = this.getBnsGroup(bnsGroupName);
        if (bdrpBnsGroup != null) {
            newBdrpBnsGroup = bdrpBnsGroup.updateAndGet(newBdrpBnsGroup.getGroup(), newBdrpBnsGroup.getServiceInstances());
        }
        if (bdrpBnsGroup == null || newBdrpBnsGroup != null && !newBdrpBnsGroup.equals(bdrpBnsGroup)) {
            this.localGroupsCache.put(bnsGroupName, newBdrpBnsGroup);
        }
        return this.getIdcInstanceFromBnsGroup(newBdrpBnsGroup);
    }

    public BdrpBnsGroup getBnsGroup(String bnsGroupName) {
        Group group = this.bnsQueryAgentProxy.getBnsQueryProxy().getServiceGroup(bnsGroupName);
        Map<String, List<Instance>> groupServiceInstances = this.getGroupServiceInstances(group == null ? null : group.getSerivceNames());
        return new BdrpBnsGroup(group, groupServiceInstances);
    }

    private Map<String, List<Instance>> getGroupServiceInstances(Set<String> serviceNames) {
        if (CollectionUtils.isEmpty(serviceNames)) {
            return null;
        }
        HashMap<String, List<Instance>> groupServiceInstances = new HashMap<String, List<Instance>>();
        for (String serviceName : serviceNames) {
            List<Instance> serviceInstances = BnsHelper.queryValidInstances(this.bnsQueryAgentProxy, serviceName);
            if (CollectionUtils.isEmpty(serviceInstances)) continue;
            groupServiceInstances.put(serviceName, serviceInstances);
        }
        return groupServiceInstances;
    }

    private List<Instance> getIdcInstanceFromBnsGroup(BdrpBnsGroup bdrpBnsGroup) {
        List<Instance> instances;
        if (bdrpBnsGroup == null || bdrpBnsGroup.getGroup() == null) {
            return null;
        }
        Group group = bdrpBnsGroup.getGroup();
        BnsGroupConf bnsGroupConfObj = this.getBnsGroupConf(group);
        Assert.notNull((Object)bnsGroupConfObj, (String)"\u6ca1\u6709\u83b7\u53d6\u5230bdrp\u7684bns group\u914d\u7f6e\u4fe1\u606f!");
        Assert.notNull(bnsGroupConfObj.getIdcMap(), (String)"\u6ca1\u6709\u83b7\u53d6\u5230bdrp\u7684bns group\u914d\u7f6e\u4e2didc_map\u4fe1\u606f!");
        BnsGroupConf.IdcMapInfo idcMapInfo = bnsGroupConfObj.getIdcMap().get(this.idc);
        if (idcMapInfo == null) {
            idcMapInfo = bnsGroupConfObj.getIdcMap().get(DEFAULT_IDC);
        }
        if (CollectionUtils.isEmpty(instances = this.getGroupIdcServices(bdrpBnsGroup, idcMapInfo))) {
            LOGGER.warn("\u6ca1\u6709\u83b7\u53d6\u5230bdrp\u7684bns group\u4e0b\u6307\u5b9aidc\u7684bns\u5b9e\u4f8b,group conf \u4e3a:" + group == null ? "" : group.getConf());
        }
        return instances;
    }

    public BnsGroupConf getBnsGroupConf(Group group) {
        String groupConf = group.getConf();
        return this.json2Object(groupConf);
    }

    public BnsGroupConf getBnsGroupConf(String bnsGroupName) {
        BdrpBnsGroup bdrpBnsGroup = this.localGroupsCache.get(bnsGroupName);
        if (bdrpBnsGroup == null || bdrpBnsGroup.getGroup() == null) {
            return null;
        }
        String groupConf = bdrpBnsGroup.getGroup().getConf();
        return this.json2Object(groupConf);
    }

    private List<Instance> getGroupIdcServices(BdrpBnsGroup bdrpBnsGroup, BnsGroupConf.IdcMapInfo idcMapInfo) {
        Set groupServiceNameList = bdrpBnsGroup.getGroup().getSerivceNames();
        if (idcMapInfo == null || CollectionUtils.isEmpty((Collection)groupServiceNameList)) {
            return null;
        }
        Set<String> preferServiceNames = this.getIdcServiceNames(groupServiceNameList, idcMapInfo.getPrefer());
        List<Instance> preferInstances = this.getInstanceByServices(preferServiceNames, bdrpBnsGroup.getServiceInstances());
        if (!CollectionUtils.isEmpty(preferInstances)) {
            return preferInstances;
        }
        Set<String> backupServiceNames = this.getIdcServiceNames(groupServiceNameList, idcMapInfo.getBackup());
        return this.getInstanceByServices(backupServiceNames, bdrpBnsGroup.getServiceInstances());
    }

    private List<Instance> getInstanceByServices(Set<String> serviceNames, Map<String, List<Instance>> groupServiceInstances) {
        if (CollectionUtils.isEmpty(serviceNames) || groupServiceInstances == null) {
            return null;
        }
        ArrayList<Instance> instances = new ArrayList<Instance>();
        for (String serviceName : serviceNames) {
            List<Instance> serviceInstances = groupServiceInstances.get(serviceName);
            if (CollectionUtils.isEmpty(serviceInstances)) continue;
            instances.addAll(serviceInstances);
        }
        return instances;
    }

    private Set<String> getIdcServiceNames(Set<String> groupSerivceNameList, Set<String> idcs) {
        HashSet<String> idcServiceNames = new HashSet<String>();
        if (!CollectionUtils.isEmpty(idcs) && !CollectionUtils.isEmpty(groupSerivceNameList)) {
            block0: for (String groupServiceName : groupSerivceNameList) {
                for (String idc : idcs) {
                    if (!groupServiceName.endsWith(IDC_SPERATOR + idc)) continue;
                    idcServiceNames.add(groupServiceName);
                    continue block0;
                }
            }
        }
        return idcServiceNames;
    }

    private BnsGroupConf json2Object(String json) {
        if (StringUtils.isEmpty((String)json)) {
            return null;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.INDENT_OUTPUT, false);
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        try {
            Map groupConf = (Map)objectMapper.readValue(json, Map.class);
            if (groupConf == null) {
                return null;
            }
            Object groupServicesConf = groupConf.get("services");
            if (groupServicesConf == null || !(groupServicesConf instanceof Map)) {
                return null;
            }
            Collection bnsGroupConfValue = ((Map)groupServicesConf).values();
            if (bnsGroupConfValue == null || bnsGroupConfValue.isEmpty()) {
                return null;
            }
            return (BnsGroupConf)objectMapper.readValue(objectMapper.writeValueAsString(bnsGroupConfValue.toArray()[0]), BnsGroupConf.class);
        }
        catch (IOException e) {
            LOGGER.error("Json Transfer BdrpBnsGroupConf Exception Occurred!", (Throwable)e);
            return null;
        }
    }

    public void setConnectTimeout(int connectTimeout) {
        this.bnsQueryAgentProxy.setConnectTimeout(connectTimeout);
    }

    public void setReadTimeout(int readTimeout) {
        this.bnsQueryAgentProxy.setReadTimeout(readTimeout);
    }
}

