/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.driver4j.bdrp.bns;

import com.baidu.driver4j.bdrp.node.NodeManager;
import com.baidu.driver4j.bns.BNSCallback;
import com.baidu.driver4j.bns.Instance;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeBnsCallback
implements BNSCallback {
    private static final Logger logger = LoggerFactory.getLogger(NodeBnsCallback.class);
    private NodeManager nodeManager;
    private List<String> serviceNames = new ArrayList<String>();

    public NodeBnsCallback() {
    }

    public NodeBnsCallback(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    public NodeBnsCallback(NodeManager nodeManager, String serviceName) {
        this.nodeManager = nodeManager;
        ArrayList<String> serviceNames = new ArrayList<String>();
        serviceNames.add(serviceName);
        this.serviceNames = serviceNames;
    }

    public List<String> getServiceNames() {
        return this.serviceNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callback(String s, List<Instance> list) {
        if (this.nodeManager == null) {
            logger.warn("nodeManager is NULL. Ignore!");
            return;
        }
        if (list == null || list.isEmpty()) {
            logger.warn("There's an empty list while refreshing the BNS nodes. Ignore!");
            return;
        }
        if (null == s || !this.serviceNames.contains(s)) {
            logger.warn("The given service name {} is NOT valid. Ignore!", (Object)s);
            return;
        }
        StringBuilder nodeList = new StringBuilder();
        for (Instance instance : list) {
            nodeList.append(instance.getIp()).append(':').append(instance.getPort()).append(';');
        }
        NodeManager nodeManager = this.nodeManager;
        synchronized (nodeManager) {
            this.nodeManager.refreshNodes(nodeList.toString());
        }
    }

    public void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    public void setServiceNames(List<String> serviceNames) {
        this.serviceNames = serviceNames;
    }
}

