/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.driver4j.bdrp.client;

import com.baidu.driver4j.bdrp.bns.BnsHelper;
import com.baidu.driver4j.bdrp.client.BdrpClient;
import com.baidu.driver4j.bdrp.client.JedisInvocationHandler;
import com.baidu.driver4j.bdrp.node.BnsGroupSupportsNodeManager;
import com.baidu.driver4j.bdrp.node.BnsSupportsNodeManager;
import com.baidu.driver4j.bdrp.node.NodeManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class BdrpClientFactory
implements InitializingBean,
DisposableBean,
FactoryBean {
    private boolean singleton = true;
    private BdrpClient client;
    private String nodes = "";
    private String idc = "default";
    private NodeManager nodeManager;
    private boolean enableBnsCallback = true;

    public void init() {
        if (this.nodeManager != null) {
            return;
        }
        Assert.hasText((String)this.nodes, (String)"property 'nodes' is blank.");
        if (BnsHelper.isBnsGroup(this.nodes)) {
            this.nodeManager = new BnsGroupSupportsNodeManager();
            ((BnsGroupSupportsNodeManager)this.nodeManager).setIdc(this.idc);
            ((BnsGroupSupportsNodeManager)this.nodeManager).setEnableCallback(this.enableBnsCallback);
        } else if (BnsHelper.isBnsService(this.nodes)) {
            BnsSupportsNodeManager eNodeManager = new BnsSupportsNodeManager();
            eNodeManager.setEnableCallback(this.enableBnsCallback);
            this.nodeManager = eNodeManager;
        } else {
            this.nodeManager = new NodeManager();
        }
        this.nodeManager.setNodes(this.nodes);
        this.nodeManager.init();
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BdrpClient getBdrpClient() {
        if (!this.isSingleton()) {
            return this.build();
        }
        if (this.client == null) {
            BdrpClientFactory bdrpClientFactory = this;
            synchronized (bdrpClientFactory) {
                if (this.client == null) {
                    this.client = this.build();
                }
            }
        }
        return this.client;
    }

    public Object getObject() throws Exception {
        return this.getBdrpClient();
    }

    public Class getObjectType() {
        return BdrpClient.class;
    }

    public void destroy() throws Exception {
        if (this.nodeManager != null) {
            this.nodeManager.destroy();
        }
    }

    protected BdrpClient build() {
        JedisInvocationHandler handler = new JedisInvocationHandler();
        handler.setNodeManager(this.nodeManager);
        return (BdrpClient)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{BdrpClient.class}, (InvocationHandler)handler);
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public String getNodes() {
        return this.nodes;
    }

    public void setNodes(String nodes) {
        this.nodes = nodes;
    }

    public void setIdc(String idc) {
        this.idc = idc;
    }

    public void setEnableBnsCallback(boolean enableBnsCallback) {
        this.enableBnsCallback = enableBnsCallback;
    }
}

