/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.driver4j.bdrp.client;

import com.baidu.driver4j.bdrp.node.BdrpNode;
import com.baidu.driver4j.bdrp.node.BdrpUtils;
import com.baidu.driver4j.bdrp.node.NodeManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import redis.clients.jedis.Jedis;

public class JedisInvocationHandler
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(JedisInvocationHandler.class);
    private NodeManager nodeManager;

    @Override
    public Object invoke(Object proxy, Method method, Object[] objects) throws Throwable {
        Assert.notNull((Object)((Object)this.nodeManager), (String)"NodeManager should NOT be null!");
        Object ret = this.processSpecialMethods(method, objects);
        if (ret != null) {
            return ret;
        }
        int maxInvokeCount = this.nodeManager.getRetryCountOnError() >= 0 ? this.nodeManager.getRetryCountOnError() + 1 : 1;
        Throwable throwable = null;
        for (int i = 0; i < maxInvokeCount; ++i) {
            throwable = null;
            Jedis jedis = null;
            BdrpNode node = this.nodeManager.getNode();
            Assert.notNull((Object)node, (String)"Can't obtain a property BdrpNode!");
            try {
                jedis = node.getJedis();
                ret = method.invoke((Object)jedis, objects);
                node.returnJedis(jedis);
                break;
            }
            catch (Throwable t) {
                if (jedis != null) {
                    node.returnBrokenJedis(jedis);
                }
                this.nodeManager.refreshDisabledNodes();
                logger.error("Exception occurred while invoking Jedis operation: " + method.getName(), t);
                throwable = t;
                continue;
            }
        }
        if (throwable != null) {
            throw throwable;
        }
        return ret;
    }

    protected Object processSpecialMethods(Method method, Object[] objects) {
        if ("getJedisFromPool".equals(method.getName())) {
            BdrpNode node = this.nodeManager.getNode();
            Assert.notNull((Object)node, (String)"Can't obtain a property BdrpNode!");
            return node.getJedis();
        }
        if ("returnJedisToPool".equals(method.getName())) {
            Assert.isTrue((objects != null && objects.length == 1 ? 1 : 0) != 0);
            Jedis jedis = (Jedis)objects[0];
            String nodeName = jedis.getClient().getHost() + ":" + jedis.getClient().getPort();
            BdrpNode node = this.nodeManager.getNode(nodeName);
            if (node == null) {
                return "OK";
            }
            if (BdrpUtils.validateJedis(jedis)) {
                node.returnJedis(jedis);
            } else {
                node.returnBrokenJedis(jedis);
                this.nodeManager.refreshDisabledNodes();
            }
            return "OK";
        }
        return null;
    }

    public void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }
}

