/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.driver4j.bdrp.node;

import com.baidu.driver4j.bdrp.node.health.HealthCriteria;
import com.baidu.driver4j.bdrp.node.health.HealthStatus;
import com.baidu.driver4j.bdrp.node.pool.BdrpPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class BdrpNode {
    private static final Logger logger = LoggerFactory.getLogger(BdrpNode.class);
    private String nodeKey;
    private HealthStatus healthStatus;
    private BdrpPool bdrpPool;

    public BdrpNode(String nodeKey, HealthCriteria healthCriteria, BdrpPool bdrpPool) {
        this.nodeKey = nodeKey;
        this.healthStatus = new HealthStatus(healthCriteria);
        this.bdrpPool = bdrpPool;
    }

    public void returnJedis(Jedis jedis) {
        if (jedis != null && this.bdrpPool != null) {
            this.bdrpPool.returnResource(jedis);
            this.healthStatus.recordSuccess();
        }
    }

    public void returnBrokenJedis(Jedis jedis) {
        logger.warn("Return broken jedis to node: {}", (Object)this.nodeKey);
        if (jedis != null && this.bdrpPool != null) {
            this.bdrpPool.returnBrokenResource(jedis);
            this.healthStatus.recordFailure();
        }
    }

    public Jedis getJedis() {
        if (this.bdrpPool == null) {
            return null;
        }
        return (Jedis)this.bdrpPool.getResource();
    }

    public void destroy() {
        try {
            this.bdrpPool.destroy();
        }
        catch (Exception e) {
            logger.error("Exception occurred while destroying bdrpPool.", (Throwable)e);
        }
    }

    public boolean isHealth() {
        return this.healthStatus.isHealth();
    }

    public String getNodeKey() {
        return this.nodeKey;
    }

    public void setNodeKey(String nodeKey) {
        this.nodeKey = nodeKey;
    }

    public HealthStatus getHealthStatus() {
        return this.healthStatus;
    }
}

