/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.driver4j.bdrp.node;

import com.baidu.driver4j.bdrp.bns.BnsGroupConfUpdater;
import com.baidu.driver4j.bdrp.bns.GroupIDCInstanceQuery;
import com.baidu.driver4j.bdrp.node.BnsSupportsNodeManager;
import com.baidu.driver4j.bns.BNSCallbackProxy;
import com.baidu.driver4j.bns.Instance;
import com.baidu.driver4j.bns.InstanceQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BnsGroupSupportsNodeManager
extends BnsSupportsNodeManager {
    private static final Logger logger = LoggerFactory.getLogger(BnsGroupSupportsNodeManager.class);
    private String idc;
    private BnsGroupConfUpdater bnsGroupConfUpdater;
    private GroupIDCInstanceQuery idcInstanceQuery;
    private int bnsGroupConfUpdateInterval = 1000;

    @Override
    public void init() {
        if (this.bnsGroupConfUpdater == null) {
            this.bnsGroupConfUpdater = new BnsGroupConfUpdater(this);
            this.bnsGroupConfUpdater.setBnsGroupConfUpdateInterval(this.bnsGroupConfUpdateInterval);
        }
        this.idcInstanceQuery = GroupIDCInstanceQuery.proxy(this.bnsServer, this.idc);
        this.idcInstanceQuery.setConnectTimeout(this.bnsConnectTimeout);
        this.idcInstanceQuery.setReadTimeout(this.bnsReadTimeout);
        this.bnsGroupConfUpdater.updateConf();
        if (this.bnsCallbackProxy == null) {
            this.bnsCallbackProxy = new BNSCallbackProxy((InstanceQuery)this.getBnsGroupInstanceQuery());
            this.bnsCallbackProxy.setInterval(this.bnsUpdateInterval);
        }
        super.init();
        if (this.enableCallback) {
            this.bnsGroupConfUpdater.start();
        }
    }

    @Override
    protected List<Instance> getInitedInstances() {
        return this.getBnsGroupInstanceQuery().queryInstances(this.bnsService);
    }

    public GroupIDCInstanceQuery getBnsGroupInstanceQuery() {
        return this.idcInstanceQuery;
    }

    @Override
    public void destroy() throws Exception {
        this.bnsGroupConfUpdater.stop();
        super.destroy();
    }

    public void setIdc(String idc) {
        this.idc = idc;
    }

    public void setBnsGroupConfUpdater(BnsGroupConfUpdater bnsGroupConfUpdater) {
        this.bnsGroupConfUpdater = bnsGroupConfUpdater;
    }

    public void setBnsGroupConfUpdateInterval(int bnsGroupConfUpdateInterval) {
        this.bnsGroupConfUpdateInterval = bnsGroupConfUpdateInterval;
    }
}

