/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.driver4j.bdrp.node;

import com.baidu.driver4j.bdrp.bns.BnsHelper;
import com.baidu.driver4j.bdrp.bns.NodeBnsCallback;
import com.baidu.driver4j.bdrp.node.NodeManager;
import com.baidu.driver4j.bns.BNSCallback;
import com.baidu.driver4j.bns.BNSCallbackProxy;
import com.baidu.driver4j.bns.BNSException;
import com.baidu.driver4j.bns.BNSQueryAgentProxy;
import com.baidu.driver4j.bns.Instance;
import com.baidu.driver4j.bns.InstanceQuery;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class BnsSupportsNodeManager
extends NodeManager {
    private static final Logger logger = LoggerFactory.getLogger(BnsSupportsNodeManager.class);
    private BNSQueryAgentProxy bnsQueryProxy;
    protected boolean enableCallback = true;
    private NodeBnsCallback nodeBnsCallback;
    protected BNSCallbackProxy bnsCallbackProxy;
    protected String bnsServer = "http://bns.noah.baidu.com/webfoot/index.php";
    protected String bnsService;
    protected int bnsReadTimeout = 10000;
    protected int bnsConnectTimeout = 10000;
    protected int bnsUpdateInterval = 5000;

    @Override
    public void init() {
        this.bnsQueryProxy = BNSQueryAgentProxy.proxy((String)this.bnsServer);
        this.initBnsQueryProxyTimeOut(this.bnsQueryProxy);
        List<Instance> instances = this.getInitedInstances();
        Assert.notNull(instances, (String)(this.bnsService + "'s instances can not be acquired."));
        logger.info("Add {} nodes to this BnsSupportNodeManager.", (Object)instances.size());
        this.setNodeList(instances);
        if (!this.enableCallback) {
            return;
        }
        if (this.nodeBnsCallback == null) {
            this.nodeBnsCallback = new NodeBnsCallback();
        }
        this.nodeBnsCallback.setNodeManager(this);
        this.nodeBnsCallback.setServiceNames(Collections.singletonList(this.bnsService));
        if (this.bnsCallbackProxy == null) {
            this.bnsCallbackProxy = this.createBNSCallbackProxy();
            this.bnsCallbackProxy.setInterval(this.bnsUpdateInterval);
        }
        this.bnsCallbackProxy.start();
        this.bnsCallbackProxy.register((BNSCallback)this.nodeBnsCallback);
        super.init();
    }

    protected BNSCallbackProxy createBNSCallbackProxy() {
        return new BNSCallbackProxy(new InstanceQuery(){

            public List<Instance> queryInstances(String serviceName) throws BNSException {
                return BnsHelper.queryValidInstances(BnsSupportsNodeManager.this.bnsQueryProxy, serviceName);
            }
        });
    }

    protected void initBnsQueryProxyTimeOut(BNSQueryAgentProxy bnsQueryProxy) {
        bnsQueryProxy.setConnectTimeout(this.bnsConnectTimeout);
        bnsQueryProxy.setReadTimeout(this.bnsReadTimeout);
    }

    protected List<Instance> getInitedInstances() {
        return BnsHelper.queryValidInstances(this.bnsQueryProxy, this.bnsService);
    }

    @Override
    public void destroy() throws Exception {
        if (this.bnsCallbackProxy != null) {
            this.bnsCallbackProxy.stop();
        }
        super.destroy();
    }

    private void setNodeList(List<Instance> instances) {
        StringBuilder nodeList = new StringBuilder();
        for (Instance instance : instances) {
            nodeList.append(instance.getIp()).append(':').append(instance.getPort()).append(";");
        }
        super.setNodes(nodeList.toString());
    }

    public void setEnableCallback(boolean enableCallback) {
        this.enableCallback = enableCallback;
    }

    public void setNodeBnsCallback(NodeBnsCallback nodeBnsCallback) {
        this.nodeBnsCallback = nodeBnsCallback;
    }

    public void setBnsCallbackProxy(BNSCallbackProxy bnsCallbackProxy) {
        this.bnsCallbackProxy = bnsCallbackProxy;
    }

    @Override
    public void setNodes(String nodes) {
        this.bnsService = nodes;
    }

    public String getBnsService() {
        return this.bnsService;
    }

    public void setBnsServer(String bnsServer) {
        this.bnsServer = bnsServer;
    }

    public void setBnsReadTimeout(int bnsReadTimeout) {
        this.bnsReadTimeout = bnsReadTimeout;
    }

    public void setBnsConnectTimeout(int bnsConnectTimeout) {
        this.bnsConnectTimeout = bnsConnectTimeout;
    }

    public void setBnsUpdateInterval(int bnsUpdateInterval) {
        this.bnsUpdateInterval = bnsUpdateInterval;
    }
}

