/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.driver4j.bdrp.node;

import com.baidu.driver4j.bdrp.node.BdrpNode;
import com.baidu.driver4j.bdrp.node.health.HealthChecker;
import com.baidu.driver4j.bdrp.node.health.HealthCriteria;
import com.baidu.driver4j.bdrp.node.pool.BdrpPool;
import com.baidu.driver4j.bdrp.node.selector.NodeSelector;
import com.baidu.driver4j.bdrp.node.selector.RandomNodeSelector;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class NodeManager
extends GenericObjectPoolConfig
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(NodeManager.class);
    private Map<String, BdrpNode> nodeMap = new HashMap<String, BdrpNode>();
    private Set<String> disabledNodeSet = new HashSet<String>();
    private String nodes = "";
    private HealthChecker healthChecker;
    private HealthCriteria healthCriteria = new HealthCriteria();
    private NodeSelector nodeSelector = new RandomNodeSelector();
    private int timeout = 2000;
    private int retryCountOnError = 0;

    public NodeManager() {
        this.setTestWhileIdle(true);
        this.setTimeBetweenEvictionRunsMillis(60000L);
        this.setMinEvictableIdleTimeMillis(300000L);
        this.setNumTestsPerEvictionRun(5);
    }

    public void init() {
        if (this.healthCriteria == null) {
            this.healthCriteria = new HealthCriteria();
        }
        this.healthChecker = new HealthChecker();
        this.healthChecker.setCheckInterval(this.healthCriteria.getTimeUnit().toSeconds(this.healthCriteria.getPeriod()));
        this.healthChecker.setNodeManager(this);
        this.healthChecker.startChecking();
        this.refreshNodes(this.nodes);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.nodeSelector);
        this.init();
    }

    public void setNodeSelector(NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public BdrpNode getNode() {
        String key = this.nodeSelector.selectNodeName(this);
        logger.info("Select a node: {}", (Object)key);
        if (!StringUtils.hasText((String)key)) {
            return null;
        }
        return this.nodeMap.get(key);
    }

    public BdrpNode getNode(String nodeName) {
        if (!StringUtils.hasText((String)nodeName)) {
            return null;
        }
        return this.nodeMap.get(nodeName);
    }

    public void refreshDisabledNodes() {
        for (Map.Entry<String, BdrpNode> entry : this.getNodeMap().entrySet()) {
            if (entry.getValue().isHealth()) {
                this.disabledNodeSet.remove(entry.getKey());
                continue;
            }
            this.disabledNodeSet.add(entry.getKey());
        }
    }

    public void refreshNodes(String nodes) {
        this.refeshNodes(nodes, false);
    }

    public void refeshNodes(String nodes, boolean force) {
        if (nodes != null && !"".equals(nodes.trim())) {
            this.nodes = nodes;
        }
        String[] nodeArr = this.splitString(this.nodes, ";");
        this.addNewNodes(nodeArr, force);
        this.removeNodes(nodeArr);
    }

    public Map<String, BdrpNode> getAvailableNodes() {
        HashMap<String, BdrpNode> availableNodes = new HashMap<String, BdrpNode>();
        for (Map.Entry<String, BdrpNode> entry : this.getNodeMap().entrySet()) {
            if (this.getDisabledNodeSet().contains(entry.getKey())) continue;
            availableNodes.put(entry.getKey(), entry.getValue());
        }
        return availableNodes;
    }

    public void destroy() throws Exception {
        if (this.healthChecker != null) {
            try {
                this.healthChecker.stopChecking();
            }
            catch (Exception e) {
                logger.warn("Exception occurred while destroying the health checker thread", (Throwable)e);
            }
        }
        for (BdrpNode node : this.nodeMap.values()) {
            try {
                node.destroy();
            }
            catch (Exception e) {
                logger.error("Exception occurred while destroying the BDRP Node " + node, (Throwable)e);
            }
        }
    }

    private void removeNodes(String[] nodeArr) {
        HashSet<String> keysToBeRemoved = new HashSet<String>();
        List<String> nodeList = Arrays.asList(nodeArr);
        for (String key : this.nodeMap.keySet()) {
            if (nodeList.contains(key)) continue;
            keysToBeRemoved.add(key);
        }
        for (String key : keysToBeRemoved) {
            BdrpNode node = this.nodeMap.remove(key);
            node.destroy();
        }
    }

    private void addNewNodes(String[] nodeArr, boolean force) {
        if (nodeArr.length <= 0) {
            return;
        }
        for (String node : nodeArr) {
            this.refreshNode(node, force);
        }
    }

    private void refreshNode(String node, boolean force) {
        if (this.nodeMap.containsKey(node) && !force) {
            return;
        }
        String[] nodeInfo = this.splitString(node, ":");
        if (nodeInfo == null) {
            return;
        }
        if (nodeInfo.length != 2) {
            logger.warn("Node format is NOT correct! Node:{}", (Object)node);
            return;
        }
        String host = nodeInfo[0];
        int port = -1;
        try {
            port = Integer.parseInt(nodeInfo[1]);
        }
        catch (NumberFormatException e) {
            logger.warn("Port of Node {} is NOT correct!", (Object)node);
            return;
        }
        this.nodeMap.put(node, new BdrpNode(node, this.healthCriteria, new BdrpPool(this, host, port, this.timeout)));
    }

    private String[] splitString(String str, String splitter) {
        if (null == str || str.length() == 0) {
            return new String[0];
        }
        return str.split(splitter);
    }

    public Map<String, BdrpNode> getNodeMap() {
        return this.nodeMap;
    }

    public Set<String> getDisabledNodeSet() {
        return this.disabledNodeSet;
    }

    public void setHealthCriteria(HealthCriteria healthCriteria) {
        this.healthCriteria = healthCriteria;
    }

    public void setNodes(String nodes) {
        this.nodes = nodes;
    }

    public String getNodes() {
        return this.nodes;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setRetryCountOnError(int retryCountOnError) {
        this.retryCountOnError = retryCountOnError;
    }

    public int getRetryCountOnError() {
        return this.retryCountOnError;
    }

    public NodeSelector getNodeSelector() {
        return this.nodeSelector;
    }
}

