/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.driver4j.bdrp.node.health;

import com.baidu.driver4j.bdrp.node.BdrpNode;
import com.baidu.driver4j.bdrp.node.NodeManager;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class HealthChecker
extends TimerTask {
    private static final Logger logger = LoggerFactory.getLogger(HealthChecker.class);
    private long checkInterval = 60L;
    private Lock lock = new ReentrantLock();
    private NodeManager nodeManager;
    private Timer timer = new Timer(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (!this.lock.tryLock()) {
                logger.warn("Last checking is not ended, ignore this checking.");
                return;
            }
            this.check();
        }
        catch (Exception e) {
            logger.error("Exception occurred while checking BDRP nodes", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void check() {
        if (this.nodeManager == null) {
            logger.warn("NodeManager is Null!");
            return;
        }
        Map<String, BdrpNode> nodeMap = this.nodeManager.getNodeMap();
        for (Map.Entry<String, BdrpNode> entry : nodeMap.entrySet()) {
            BdrpNode node = entry.getValue();
            Jedis jedis = null;
            try {
                jedis = node.getJedis();
                jedis.get("DO_NOT_USE_THIS_KEY_JUST_FOR_TEST_IN_BAIDU_DRIVER".getBytes());
                node.returnJedis(jedis);
                node.getHealthStatus().resetCheckingFailureCount();
            }
            catch (Exception e) {
                if (jedis != null) {
                    node.returnBrokenJedis(jedis);
                }
                logger.warn("Exception occurred while checking BDRP Node " + entry.getKey(), (Throwable)e);
                node.getHealthStatus().recordCheckingFailure();
            }
        }
        this.nodeManager.refreshDisabledNodes();
    }

    public void stopChecking() {
        this.timer.cancel();
    }

    public void startChecking() {
        this.timer.scheduleAtFixedRate((TimerTask)this, this.checkInterval * 1000L, this.checkInterval * 1000L);
    }

    public void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }
}

