/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.driver4j.bdrp.node.health;

import com.baidu.driver4j.bdrp.node.health.HealthCriteria;
import java.util.concurrent.atomic.AtomicInteger;

public class HealthStatus {
    private HealthCriteria healthCriteria = new HealthCriteria();
    private AtomicInteger continuousCheckingFailureCount = new AtomicInteger(0);
    private int continuousFailureCount = 0;
    private long lastRefreshTimeStamp = System.currentTimeMillis();

    public HealthStatus() {
    }

    public HealthStatus(HealthCriteria healthCriteria) {
        this.healthCriteria = healthCriteria;
    }

    public boolean isHealth() {
        return this.isHealthCheckingFailureCountUnderThreshold() && this.isFailureCountUnderThreshold();
    }

    public boolean isHealthCheckingFailureCountUnderThreshold() {
        return this.continuousCheckingFailureCount.intValue() < this.healthCriteria.getCheckingFailThreshold();
    }

    public boolean isFailureCountUnderThreshold() {
        return this.continuousFailureCount < this.healthCriteria.getDisableThreshold();
    }

    public boolean refreshFailureCount() {
        long currentTimeStamp = System.currentTimeMillis();
        long duration = currentTimeStamp - this.lastRefreshTimeStamp;
        if (this.healthCriteria.getTimeUnit().toMillis(this.healthCriteria.getPeriod()) >= duration) {
            this.continuousFailureCount = 0;
            this.lastRefreshTimeStamp = currentTimeStamp;
            return true;
        }
        return false;
    }

    public void resetCheckingFailureCount() {
        this.continuousCheckingFailureCount.set(0);
    }

    public void recordCheckingFailure() {
        this.continuousCheckingFailureCount.incrementAndGet();
    }

    public void recordSuccess() {
        this.continuousFailureCount = 0;
    }

    public void recordFailure() {
        ++this.continuousFailureCount;
    }

    public void setHealthCriteria(HealthCriteria healthCriteria) {
        this.healthCriteria = healthCriteria;
    }
}

