/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.driver4j.bdrp.node.pool;

import com.baidu.driver4j.bdrp.node.BdrpUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.Jedis;

public class BdrpFactory
implements PooledObjectFactory<Jedis> {
    private static final Logger logger = LoggerFactory.getLogger(BdrpFactory.class);
    private final String host;
    private final int port;
    private final int timeout;
    private final String password;
    private final int database;
    private final String clientName;

    public BdrpFactory(String host, int port, int timeout, String password, int database) {
        this(host, port, timeout, password, database, null);
    }

    public BdrpFactory(String host, int port, int timeout, String password, int database, String clientName) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.password = password;
        this.database = database;
        this.clientName = clientName;
    }

    public void activateObject(PooledObject<Jedis> pooledJedis) throws Exception {
        BinaryJedis jedis = (BinaryJedis)pooledJedis.getObject();
        if (jedis.getDB() != (long)this.database) {
            jedis.select(this.database);
        }
    }

    public void destroyObject(PooledObject<Jedis> pooledJedis) throws Exception {
        BinaryJedis jedis = (BinaryJedis)pooledJedis.getObject();
        if (!jedis.isConnected()) {
            return;
        }
        try {
            try {
                jedis.quit();
            }
            catch (Exception e) {
                // empty catch block
            }
            jedis.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PooledObject<Jedis> makeObject() throws Exception {
        Jedis jedis = new Jedis(this.host, this.port, this.timeout);
        jedis.connect();
        if (null != this.password) {
            jedis.auth(this.password);
        }
        if (this.database != 0) {
            jedis.select(this.database);
        }
        if (this.clientName != null) {
            jedis.clientSetname(this.clientName);
        }
        return new DefaultPooledObject((Object)jedis);
    }

    public void passivateObject(PooledObject<Jedis> pooledJedis) throws Exception {
    }

    public boolean validateObject(PooledObject<Jedis> pooledJedis) {
        return BdrpUtils.validateJedis((Jedis)pooledJedis.getObject());
    }
}

