/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.driver4j.bdrp.node.selector;

import com.baidu.driver4j.bdrp.node.NodeManager;
import com.baidu.driver4j.bdrp.node.selector.NodeSelector;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomNodeSelector
implements NodeSelector {
    private static final Logger logger = LoggerFactory.getLogger(RandomNodeSelector.class);
    private Random random = new Random();

    @Override
    public String selectNodeName(NodeManager nodeManager) {
        String key = null;
        Set<String> nodeSet = nodeManager.getAvailableNodes().keySet();
        if (nodeSet == null || nodeSet.isEmpty()) {
            logger.warn("Can not find available node with the given NodeManager!");
            return null;
        }
        int pos = this.random.nextInt(nodeSet.size());
        int idx = 0;
        for (String k : nodeSet) {
            if (idx++ < pos) continue;
            key = k;
            break;
        }
        logger.debug("Select a KEY: {}, {}/{}", new Object[]{key, pos, nodeSet.size()});
        return key;
    }
}

