/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.driver4j.bdrp.node.selector;

import com.baidu.driver4j.bdrp.node.NodeManager;
import com.baidu.driver4j.bdrp.node.selector.NodeSelector;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobbinNodeSelector
implements NodeSelector {
    private static final Logger logger = LoggerFactory.getLogger(RoundRobbinNodeSelector.class);
    private static final AtomicInteger currentPos = new AtomicInteger(-1);

    @Override
    public String selectNodeName(NodeManager nodeManager) {
        String key = null;
        Set<String> nodeSet = nodeManager.getAvailableNodes().keySet();
        if (nodeSet == null || nodeSet.isEmpty()) {
            logger.warn("Can not find available node with the given NodeManager!");
            return null;
        }
        currentPos.set(currentPos.incrementAndGet() % nodeSet.size());
        int pos = currentPos.get();
        int idx = 0;
        for (String k : nodeSet) {
            if (idx++ < pos) continue;
            key = k;
            break;
        }
        logger.debug("Select a KEY: {}, {}/{}", new Object[]{key, pos, nodeSet.size()});
        return key;
    }

    public void reset() {
        currentPos.set(0);
    }
}

