/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bifromq.plugin.settingprovider;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import java.time.Duration;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Setting
extends Enum<Setting> {
    public static final /* enum */ Setting DebugModeEnabled = new Setting(Boolean.class, val -> true, false);
    public static final /* enum */ Setting BoostModeEnabled = new Setting(Boolean.class, val -> true, false);
    public static final /* enum */ Setting MaxTopicLevelLength = new Setting(Integer.class, val -> (Integer)val > 0, 40);
    public static final /* enum */ Setting MaxTopicLevels = new Setting(Integer.class, val -> (Integer)val > 0, 16);
    public static final /* enum */ Setting MaxTopicLength = new Setting(Integer.class, val -> (Integer)val > 0 && (Integer)val < 65536, 255);
    public static final /* enum */ Setting MaxSharedGroupMembers = new Setting(Integer.class, val -> (Integer)val > 0, 200);
    public static final /* enum */ Setting MaxTopicFiltersPerInbox = new Setting(Integer.class, val -> (Integer)val > 0, 100);
    public static final /* enum */ Setting MsgPubPerSec = new Setting(Integer.class, val -> (Integer)val >= 0 && (Integer)val <= 1000, 200);
    public static final /* enum */ Setting InBoundBandWidth = new Setting(Long.class, val -> (Long)val >= 0L, 524288L);
    public static final /* enum */ Setting OutBoundBandWidth = new Setting(Long.class, val -> (Long)val >= 0L, 524288L);
    public static final /* enum */ Setting ForceTransient = new Setting(Boolean.class, val -> true, false);
    public static final /* enum */ Setting ByPassPermCheckError = new Setting(Boolean.class, val -> true, true);
    public static final /* enum */ Setting MaxUserPayloadBytes = new Setting(Integer.class, val -> (Integer)val > 0 && (Integer)val <= 0x100000, 262144);
    public static final /* enum */ Setting MaxTopicFiltersPerSub = new Setting(Integer.class, val -> (Integer)val > 0 && (Integer)val <= 100, 10);
    public static final /* enum */ Setting OfflineExpireTimeSeconds = new Setting(Long.class, val -> (Long)val > 0L, 86400L);
    public static final /* enum */ Setting OfflineQueueSize = new Setting(Integer.class, val -> (Integer)val > 0 && (Integer)val <= 100000, 1000);
    public static final /* enum */ Setting OfflineOverflowDropOldest = new Setting(Boolean.class, val -> true, false);
    public static final /* enum */ Setting RetainedTopicLimit = new Setting(Integer.class, val -> (Integer)val >= 0, 10);
    public static final /* enum */ Setting RetainMessageMatchLimit = new Setting(Integer.class, val -> (Integer)val >= 0, 10);
    public static final /* enum */ Setting RetainEnabled = new Setting(Boolean.class, val -> true, true);
    public static final /* enum */ Setting DistReservedUnitInterval = new Setting(Long.class, val -> (Long)val > 0L && (Long)val <= 0xFFFFFFFFL, 0xFFFFFFFFL);
    public static final /* enum */ Setting DistLimitUnitInterval = new Setting(Long.class, val -> (Long)val >= 0L && (Long)val <= 0xFFFFFFFFL, 0L);
    @Generated
    private static final Logger log;
    public final Class<?> valueType;
    final Predicate<Object> validator;
    final Object initial;
    final Cache<String, Object> currentVals;
    private static final /* synthetic */ Setting[] $VALUES;

    public static Setting[] values() {
        return (Setting[])$VALUES.clone();
    }

    public static Setting valueOf(String name) {
        return Enum.valueOf(Setting.class, name);
    }

    private Setting(Class<?> valueType, Predicate<Object> validator, Object initial) {
        this.valueType = valueType;
        this.validator = validator;
        initial = this.resolve(initial);
        assert (this.isValid(initial));
        this.initial = initial;
        this.currentVals = Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(5L)).scheduler(Scheduler.systemScheduler()).build();
    }

    public <R> R current(String tenantId) {
        return (R)this.currentVals.asMap().getOrDefault(tenantId, this.initial);
    }

    public <R> boolean isValid(R val) {
        if (!this.valueType.isInstance(val)) {
            return false;
        }
        return this.validator.test(val);
    }

    void current(String tenantId, Object newVal) {
        assert (this.isValid(newVal));
        if (!newVal.equals(this.initial)) {
            this.currentVals.put((Object)tenantId, newVal);
        } else {
            this.currentVals.invalidate((Object)tenantId);
        }
    }

    Object resolve(Object initial) {
        String override = System.getProperty(this.name());
        if (override != null) {
            try {
                if (this.valueType == Integer.class) {
                    return Integer.parseInt(override);
                }
                if (this.valueType == Long.class) {
                    return Long.parseLong(override);
                }
                if (this.valueType == Boolean.class) {
                    return Boolean.parseBoolean(override);
                }
            }
            catch (Throwable e) {
                log.error("Unable to parse setting value from system property: setting={}, value={}", (Object)this.name(), (Object)override);
                return initial;
            }
        }
        return initial;
    }

    private static /* synthetic */ Setting[] $values() {
        return new Setting[]{DebugModeEnabled, BoostModeEnabled, MaxTopicLevelLength, MaxTopicLevels, MaxTopicLength, MaxSharedGroupMembers, MaxTopicFiltersPerInbox, MsgPubPerSec, InBoundBandWidth, OutBoundBandWidth, ForceTransient, ByPassPermCheckError, MaxUserPayloadBytes, MaxTopicFiltersPerSub, OfflineExpireTimeSeconds, OfflineQueueSize, OfflineOverflowDropOldest, RetainedTopicLimit, RetainMessageMatchLimit, RetainEnabled, DistReservedUnitInterval, DistLimitUnitInterval};
    }

    static {
        $VALUES = Setting.$values();
        log = LoggerFactory.getLogger(Setting.class);
    }
}

