/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bifromq.plugin.settingprovider;

import com.baidu.bifromq.plugin.settingprovider.ISettingProvider;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Setting
extends Enum<Setting> {
    public static final /* enum */ Setting MQTT3Enabled = new Setting(Boolean.class, val -> true, true);
    public static final /* enum */ Setting MQTT4Enabled = new Setting(Boolean.class, val -> true, true);
    public static final /* enum */ Setting MQTT5Enabled = new Setting(Boolean.class, val -> true, true);
    public static final /* enum */ Setting DebugModeEnabled = new Setting(Boolean.class, val -> true, false);
    public static final /* enum */ Setting ForceTransient = new Setting(Boolean.class, val -> true, false);
    public static final /* enum */ Setting ByPassPermCheckError = new Setting(Boolean.class, val -> true, true);
    public static final /* enum */ Setting PayloadFormatValidationEnabled = new Setting(Boolean.class, val -> true, true);
    public static final /* enum */ Setting RetainEnabled = new Setting(Boolean.class, val -> true, true);
    public static final /* enum */ Setting WildcardSubscriptionEnabled = new Setting(Boolean.class, val -> true, true);
    public static final /* enum */ Setting SubscriptionIdentifierEnabled = new Setting(Boolean.class, val -> true, true);
    public static final /* enum */ Setting SharedSubscriptionEnabled = new Setting(Boolean.class, val -> true, true);
    public static final /* enum */ Setting MaximumQoS = new Setting(Integer.class, val -> (Integer)val == 0 || (Integer)val == 1 || (Integer)val == 2, 2);
    public static final /* enum */ Setting MaxTopicLevelLength = new Setting(Integer.class, val -> (Integer)val > 0, 40);
    public static final /* enum */ Setting MaxTopicLevels = new Setting(Integer.class, val -> (Integer)val > 0, 16);
    public static final /* enum */ Setting MaxTopicLength = new Setting(Integer.class, val -> (Integer)val > 0 && (Integer)val < 65536, 255);
    public static final /* enum */ Setting MaxTopicAlias = new Setting(Integer.class, val -> (Integer)val >= 0 && (Integer)val < 65536, 10);
    public static final /* enum */ Setting MaxSharedGroupMembers = new Setting(Integer.class, val -> (Integer)val > 0, 200);
    public static final /* enum */ Setting MaxTopicFiltersPerInbox = new Setting(Integer.class, val -> (Integer)val > 0, 100);
    public static final /* enum */ Setting MsgPubPerSec = new Setting(Integer.class, val -> (Integer)val > 0 && (Integer)val <= 1000, 200);
    public static final /* enum */ Setting ReceivingMaximum = new Setting(Integer.class, val -> (Integer)val > 0 && (Integer)val <= 65535, 200);
    public static final /* enum */ Setting InBoundBandWidth = new Setting(Long.class, val -> (Long)val >= 0L, 524288L);
    public static final /* enum */ Setting OutBoundBandWidth = new Setting(Long.class, val -> (Long)val >= 0L, 524288L);
    public static final /* enum */ Setting MaxUserPayloadBytes = new Setting(Integer.class, val -> (Integer)val > 0 && (Integer)val <= 0x10000000, 262144);
    public static final /* enum */ Setting MaxResendTimes = new Setting(Integer.class, val -> (Integer)val >= 0, 3);
    public static final /* enum */ Setting ResendTimeoutSeconds = new Setting(Integer.class, val -> (Integer)val > 0, 10);
    public static final /* enum */ Setting MaxTopicFiltersPerSub = new Setting(Integer.class, val -> (Integer)val > 0 && (Integer)val <= 100, 10);
    public static final /* enum */ Setting MaxSessionExpirySeconds = new Setting(Integer.class, val -> (Integer)val > 0, 86400);
    public static final /* enum */ Setting SessionInboxSize = new Setting(Integer.class, val -> (Integer)val > 0 && (Integer)val <= 65535, 1000);
    public static final /* enum */ Setting QoS0DropOldest = new Setting(Boolean.class, val -> true, false);
    public static final /* enum */ Setting RetainMessageMatchLimit = new Setting(Integer.class, val -> (Integer)val >= 0, 10);
    @Generated
    private static final Logger log;
    public final Class<?> valueType;
    private final Predicate<Object> validator;
    private final Object defVal;
    private volatile ISettingProvider settingProvider;
    private static final /* synthetic */ Setting[] $VALUES;

    public static Setting[] values() {
        return (Setting[])$VALUES.clone();
    }

    public static Setting valueOf(String name) {
        return Enum.valueOf(Setting.class, name);
    }

    private Setting(Class<?> valueType, Predicate<Object> validator, Object defValue) {
        this.valueType = valueType;
        this.validator = validator;
        this.defVal = this.resolve(defValue);
        assert (this.isValid(this.defVal));
    }

    public <R> R current(String tenantId) {
        return this.settingProvider == null ? this.initialValue() : this.settingProvider.provide(this, tenantId);
    }

    public <R> boolean isValid(R val) {
        if (!this.valueType.isInstance(val)) {
            return false;
        }
        return this.validator.test(val);
    }

    <R> R initialValue() {
        return (R)this.defVal;
    }

    void setProvider(ISettingProvider provider) {
        this.settingProvider = provider;
    }

    Object resolve(Object initial) {
        String override = System.getProperty(this.name());
        if (override != null) {
            try {
                if (this.valueType == Integer.class) {
                    return Integer.parseInt(override);
                }
                if (this.valueType == Long.class) {
                    return Long.parseLong(override);
                }
                if (this.valueType == Boolean.class) {
                    return Boolean.parseBoolean(override);
                }
            }
            catch (Throwable e) {
                log.error("Unable to parse setting value from system property: setting={}, value={}", (Object)this.name(), (Object)override);
                return initial;
            }
        }
        return initial;
    }

    private static /* synthetic */ Setting[] $values() {
        return new Setting[]{MQTT3Enabled, MQTT4Enabled, MQTT5Enabled, DebugModeEnabled, ForceTransient, ByPassPermCheckError, PayloadFormatValidationEnabled, RetainEnabled, WildcardSubscriptionEnabled, SubscriptionIdentifierEnabled, SharedSubscriptionEnabled, MaximumQoS, MaxTopicLevelLength, MaxTopicLevels, MaxTopicLength, MaxTopicAlias, MaxSharedGroupMembers, MaxTopicFiltersPerInbox, MsgPubPerSec, ReceivingMaximum, InBoundBandWidth, OutBoundBandWidth, MaxUserPayloadBytes, MaxResendTimes, ResendTimeoutSeconds, MaxTopicFiltersPerSub, MaxSessionExpirySeconds, SessionInboxSize, QoS0DropOldest, RetainMessageMatchLimit};
    }

    static {
        $VALUES = Setting.$values();
        log = LoggerFactory.getLogger(Setting.class);
    }
}

