package com.baidu.bigpipe.common.support;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

/**
 * 
 * 对jackson进行封装用于处理json的工具类
 * 
 * @author <a href="mailto:zhangxu04@baidu.com">Zhang Xu</a>
 * @version 2013-4-17 下午4:25:22
 */
public abstract class JsonUtils {

    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);

    private static final Gson gson = new GsonBuilder().create();

    /**
     * 将对象转化成json string
     *
     * @param object 对象
     * @return json string
     */
    public static String toJson(Object object) {
        return toJson(object,false);
    }

    /**
     * 将对象转化为json string，支持指定输出json时是否忽略为空的属性
     *
     * @param object 对象
     * @param ignoreEmpty 是否忽略为空的属性
     * @return json string
     */
    public static String toJson(Object object, boolean ignoreEmpty) {
        String jsonString = "";
        try {
            jsonString = gson.toJson(object);
        } catch (Exception e) {
            log.warn("json error:" + e.getMessage());
        }
        return jsonString;

    }
    /**
     * 将json string转化为指定类的对象
     *
     * @param jsonString json string
     * @param c 需要转化的类型
     * @return java 对象
     */
    public static Object json2Object(String jsonString, Class<?> c) {

        if (jsonString == null || "".equals(jsonString)) {
            return "";
        } else {
        	return gson.fromJson(jsonString, c);
        }
    }

    
}
