package com.baidu.bigpipe.driver;

import com.baidu.bigpipe.driver.converter.sub.MessageBodyConverter;
import com.baidu.bigpipe.driver.converter.sub.StringMessageBodyConverter;
import com.baidu.bigpipe.position.store.SubcribePositionStore;
import com.baidu.bigpipe.transport.conf.BigPipeConf;
import com.baidu.bigpipe.transport.factory.AsynchronousSubscriberFactory;
import com.baidu.bigpipe.transport.factory.DefaultAsynchronousSubscriberFactory;
import com.baidu.bigpipe.transport.sub.AsynchronousSubscriber;
import com.baidu.bigpipe.transport.sub.BigpipeMessageListener;

/**
 * 实现{@link com.baidu.bigpipe.driver.ListenerSubscriber ListenerSubscriber}接口，封装
 * {@link com.baidu.bigpipe.transport.sub.AsynchronousSubscriber AsynchronousSubscriber}, 异步订阅消息并消费消息，消费步骤如下：
 * <ul>
 * <li>监听并接收消息,通过 {@link com.baidu.bigpipe.transport.sub.AsynchronousSubscriber AsynchronousSubscriber}实现</li>
 * <li>转化byte[]类型消息成为java对象,通过{@link com.baidu.bigpipe.driver.converter.sub.MessageBodyConverter MessageBodyConverter}实现
 * </li>
 * <li>消费消息，通过{@link com.baidu.bigpipe.transport.sub.BigpipeMessageListener BigpipeMessageListener}实现</li>
 * <li>消息成功消费后记录消息在bigpipe中为位置,通过{@link com.baidu.bigpipe.position.store.SubcribePositionStore SubcribePositionStore}实现</li>
 * </ul>
 * 
 * @author hexiufeng
 * 
 */
public class DefaultListenerSubscriber implements ListenerSubscriber {
    /**
     * 消息的订阅者
     */
    private AsynchronousSubscriber subcriber;
    /**
     * 消息的转化器
     */
    private MessageBodyConverter bodyConverter = new StringMessageBodyConverter();
    /**
     * 消息消费对象
     */
    private BigpipeMessageListener messageListener;
    /**
     * 订阅点存储器
     */
    private SubcribePositionStore positionStore;

    private AsynchronousSubscriberFactory subFactory = new DefaultAsynchronousSubscriberFactory();
    /**
     * bigpipe配置
     */
    private BigPipeConf conf;

    public BigpipeMessageListener getMessageListener() {
        return messageListener;
    }

    public void setMessageListener(BigpipeMessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public MessageBodyConverter getBodyConverter() {
        return bodyConverter;
    }

    public void setBodyConverter(MessageBodyConverter bodyConverter) {
        this.bodyConverter = bodyConverter;
    }

    public SubcribePositionStore getPositionStore() {
        return positionStore;
    }

    public void setPositionStore(SubcribePositionStore positionStore) {
        this.positionStore = positionStore;
    }

    public BigPipeConf getConf() {
        return conf;
    }

    public void setConf(BigPipeConf conf) {
        this.conf = conf;
    }

    public AsynchronousSubscriber getSubcriber() {
        return subcriber;
    }

    public AsynchronousSubscriberFactory getSubFactory() {
        return subFactory;
    }

    public void setSubFactory(AsynchronousSubscriberFactory subFactory) {
        this.subFactory = subFactory;
    }

    @Override
    public void init() {
        if (subcriber == null) {
            subcriber = subFactory.factory(bodyConverter, positionStore);
        }
        // 开启订阅,内部会开启线程监控订阅
        subcriber.startSubscribe(messageListener, conf);
    }

    @Override
    public void shutDown() {
        subcriber.shutDown();
    }

}
