/*
 * Copyright (C) 2016 Baidu, Inc. All Rights Reserved.
 */
package com.baidu.bigpipe.driver;

import com.baidu.bigpipe.driver.converter.sub.MessageBodyConverter;
import com.baidu.bigpipe.driver.converter.sub.StringMessageBodyConverter;
import com.baidu.bigpipe.position.store.SubcribePositionStore;
import com.baidu.bigpipe.transport.conf.BigPipeConf;
import com.baidu.bigpipe.transport.factory.queue.AsynchronousQueueSubscriberFactory;
import com.baidu.bigpipe.transport.factory.queue.DefaultAsynchronousQueueSubscriberFactory;
import com.baidu.bigpipe.transport.queue.AsynchronousQueueSubscriber;
import com.baidu.bigpipe.transport.sub.PipeletIdAwareBigpipeMessageListener;

/**
 * 实现{@link QueueListenerSubscriber QueueListenerSubscriber}接口，封装
 * {@link AsynchronousQueueSubscriberFactory AsynchronousQueueSubscriberFactory}, 异步订阅消息并消费消息，消费步骤如下：
 * <ul>
 * <li>监听并接收消息,通过 {@link AsynchronousQueueSubscriber AsynchronousQueueSubscriber}实现</li>
 * <li>转化byte[]类型消息成为java对象,通过{@link MessageBodyConverter MessageBodyConverter}实现
 * </li>
 * <li>消费消息，通过{@link PipeletIdAwareBigpipeMessageListener BigpipeQueueMessageListener}实现</li>
 * <li>消息成功消费后,如果不抛出异常,</li>
 * <li>通过{@link com.baidu.bigpipe.transport.queue.AsynchronousQueueSubscriberBioImpl#sendAcknowledgement}消息回执</li>
 * </ul>
 *
 * @author liangxiaojie
 */
public class DefaultQueueListenerSubscriber implements QueueListenerSubscriber {
    /**
     * 消息的订阅者
     */
    private AsynchronousQueueSubscriber subcriber;
    /**
     * 消息的转化器
     */
    private MessageBodyConverter bodyConverter = new StringMessageBodyConverter();
    /**
     * 消息消费对象
     */
    private PipeletIdAwareBigpipeMessageListener messageListener;
    /**
     * 订阅点存储器
     */
    private SubcribePositionStore positionStore;

    private AsynchronousQueueSubscriberFactory subFactory;
    /**
     * bigpipe配置
     */
    private BigPipeConf conf;

    public PipeletIdAwareBigpipeMessageListener getMessageListener() {
        return messageListener;
    }

    public void setMessageListener(PipeletIdAwareBigpipeMessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public MessageBodyConverter getBodyConverter() {
        return bodyConverter;
    }

    public void setBodyConverter(MessageBodyConverter bodyConverter) {
        this.bodyConverter = bodyConverter;
    }

    public SubcribePositionStore getPositionStore() {
        return positionStore;
    }

    public void setPositionStore(SubcribePositionStore positionStore) {
        this.positionStore = positionStore;
    }

    public BigPipeConf getConf() {
        return conf;
    }

    public void setConf(BigPipeConf conf) {
        this.conf = conf;
    }

    public AsynchronousQueueSubscriber getSubcriber() {
        return subcriber;
    }

    public AsynchronousQueueSubscriberFactory getSubFactory() {
        return subFactory;
    }

    public void setSubFactory(AsynchronousQueueSubscriberFactory subFactory) {
        this.subFactory = subFactory;
    }

    @Override
    public void init() {
        if (subFactory == null) {
            subFactory = new DefaultAsynchronousQueueSubscriberFactory(conf,
                    bodyConverter,
                    messageListener);
        }
        if (subcriber == null) {
            subcriber = subFactory.factory();
        }
        // 开启订阅,内部会开启线程监控订阅
        subcriber.startSubscribe();
    }

    @Override
    public void shutDown() {
        subcriber.shutDown();
    }

}
