package com.baidu.bigpipe.driver;

import com.baidu.bigpipe.driver.converter.pub.MessageConverter;
import com.baidu.bigpipe.exp.PushException;
import com.baidu.bigpipe.protocol.BigpipePackBuilder;
import com.baidu.bigpipe.transport.pub.SendFutrue;

/**
 * 非堵塞的消息发送客户端，它对{@link com.baidu.bigpipe.transport.pub.AsynchronousPublisher AsynchronousPublisher}做了封装， 对外提供更简单的api
 * 
 * <pre>
 * change log by xiemalin:
 * 移出了 publish(Object message) 方法, 不应该把MessageCOnverter放到内部处理,以方便用户扩展,同时解耦依赖
 * </pre>
 * 
 * @author hexiufeng
 * @author xiemalin 
 * 
 */
public interface NoneBlockingBigpipePubClient {
    
    /**
     * 发送单个消息
     * 
     * @param message 单个消息
     * @param messageConverter 消息转换
     * @return {@link SendFutrue}对象
     * @throws PushException 当发送线程内部发送错误时会产生该异常
     */
    SendFutrue publish(Object message, MessageConverter messageConverter) throws PushException;
    
    
    
    /**
     * 发送单个消息
     * @param message byte array message
     * @return {@link SendFutrue}对象
     * @throws PushException 当发送线程内部发送错误时会产生该异常
     */
    SendFutrue publish(byte[] message) throws PushException;
    

    /**
     * 发送c-api协议的打包消息
     * 
     * @param packBuilder {@link BigpipePackBuilder}对象，描述 一包数据
     * @return {@link SendFutrue}对象
     * @throws PushException 当发送线程内部发送错误时会产生该异常
     */
    SendFutrue publishPack(BigpipePackBuilder packBuilder) throws PushException;
}
