package com.baidu.bigpipe.driver.converter.pub;

import com.baidu.bigpipe.common.support.JsonUtils;

/**
 * 把对象先转化为jsonstring，再转化为utf-8的byte[]
 * 
 * @author hexiufeng
 * @author xiemalin modify to extends from {@link StringMessageConverter}
 */
public class JsonMessageConverter extends StringMessageConverter {

    @Override
    public byte[] convert(Object o) {
        String json = JsonUtils.toJson(o);
        if (json == null)
            return null;

        byte[] buf = null;
        buf = super.convert(json);
        return buf;
    }

}
