/*
 * Copyright 2015 the original author or authors.
 *
 * Licensed under the BAIDU
 */
package com.baidu.bigpipe.driver.converter.pub;

/**
 * 
 * Helper class for {@link MessageConverter}
 * 
 * @author xiemalin
 * 
 */
public class MessageConverterHelper {
	
	/**
	 * STRING_MESSAGE_CONVERTER shared instance 
	 */
	private static final MessageConverter STRING_MESSAGE_CONVERTER = new StringMessageConverter();
	
	/**
	 * JSONMESSAGE_CONVERTER  shared instance 
	 */
	private static final MessageConverter JSONMESSAGE_CONVERTER = new JsonMessageConverter();
	
	
	/**
	 * get {@link StringMessageConverter} instance
	 * @return
	 */
	public static final MessageConverter getStringMessageConverter() {
		return STRING_MESSAGE_CONVERTER;
	}
	
	/**
	 * get {@link JsonMessageConverter} instance
	 * @return
	 */
	public static final MessageConverter getJsonMessageConverter() {
		return JSONMESSAGE_CONVERTER;
	}

	/**
	 * do convert action the target object
	 * @param object target object
	 * @param messageConverter {@link MessageConverter}
	 * @return byte array
	 * @exception RuntimeException in case of any exception during converting 
	 */
	public static byte[] convert(Object object, MessageConverter messageConverter) {
		if (object == null) {
			throw new RuntimeException("param 'object' is null.");
		}
		if (messageConverter == null) {
			throw new RuntimeException("param 'messageConverter' is null.");
		}
		byte[] message = messageConverter.convert(object);

		return message;
	}

}
