package com.baidu.bigpipe.driver.converter.pub;

import java.io.UnsupportedEncodingException;

/**
 * 发送消息本身是String时，直接转化为该String的utf-8 byte[]
 * 
 * @author hexiufeng
 * @author xiemalin add encode field
 */
public class StringMessageConverter implements MessageConverter {

	private static final String DEFALUT_ENCODE = "utf-8";

	private String encode = DEFALUT_ENCODE;

	/**
	 * setter method for property encode
	 * 
	 * @param encode
	 *            the encode to set
	 */
	public void setEncode(String encode) {
		this.encode = encode;
	}
	
	/**
	 * getter method for property encode
	 * @return the encode
	 */
	protected String getEncode() {
		return encode;
	}

	/**
	 * 
	 */
	public StringMessageConverter() {
		this(DEFALUT_ENCODE);
	}

	public StringMessageConverter(String encode) {
		setEncode(encode);
	}

	@Override
	public byte[] convert(Object o) {
		if (o instanceof String) {
			try {
				return ((String) o).getBytes(encode);
			} catch (UnsupportedEncodingException e) {
				throw new RuntimeException(e.getMessage(), e);
			}
		}
		throw new RuntimeException("Only string type accepted.");
	}

}
