package com.baidu.bigpipe.driver.converter.sub;

import java.io.UnsupportedEncodingException;

import com.baidu.bigpipe.common.support.JsonUtils;

/**
 * 消息可以被转化为json string，再有json转化为java对象的转换器
 * 
 * @author hexiufeng
 * 
 */
public class JsonMessageBodyConverter implements MessageBodyConverter<Object> {
	private Class<?> claz;
	private String charSetName = "utf-8";

	/**
	 * 从json转换的目标class name，full class name
	 * 
	 * @param className
	 */
	public void setTargetClassName(String className) {
		try {
			claz = Class.forName(className);
		} catch (ClassNotFoundException e) {
			throw new RuntimeException(e.getMessage(), e);
		}
	}

	public void setCharSetName(String charSetName) {
		this.charSetName = charSetName;
	}

	@Override
	public Object bin2Object(byte[] buf) {
		try {
			String json = new String(buf, charSetName);
			return JsonUtils.json2Object(json, claz);
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e.getMessage(), e);
		}
	}

}
