package com.baidu.bigpipe.driver.converter.sub;

import java.io.UnsupportedEncodingException;


/**
 * 消息是一个可以被转化为 string的转换器
 * 
 * @author hexiufeng
 * @author xiemalin
 */
public class StringMessageBodyConverter implements MessageBodyConverter<String> {

    private static final String DEFALUT_ENCODE = "utf-8";

	private String encode = DEFALUT_ENCODE;

	/**
	 * setter method for property encode
	 * 
	 * @param encode
	 *            the encode to set
	 */
	public void setEncode(String encode) {
		this.encode = encode;
	}
	
	/**
	 * getter method for property encode
	 * @return the encode
	 */
	protected String getEncode() {
		return encode;
	}
	
	/**
	 * 
	 */
	public StringMessageBodyConverter() {
		this(DEFALUT_ENCODE);
	}

	public StringMessageBodyConverter(String encode) {
		setEncode(encode);
	}
	
	
    @Override
    public String bin2Object(byte[] buf) {
        try {
            return new String(buf, encode);
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}
