package com.baidu.bigpipe.position.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

/**
 * 以本地文件为存储媒体的订阅点存储器实现
 * 
 * @author hexiufeng
 * 
 */
public class LocalFileSubcribePositionStore implements SubcribePositionStore {
    /**
     * 文件路径
     */
    private String rootPath;
    /**
     * 文件名称
     */
    private String fileName;

    public String getRootPath() {
        return rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void store(long position) {
        FileChannel chl = openFile(true);
        try {
            String line = position + "";
            ByteBuffer buf = ByteBuffer.wrap(line.getBytes("utf-8"));
            while (buf.remaining() > 0) {
                chl.write(buf);
            }
        } catch (UnsupportedEncodingException e) {
            // ignore
        } catch (IOException e) {
            throw new RuntimeException(e);
        } finally {
            safeCloseFile(chl);
        }
    }

    @Override
    public Long loadPosition() {
        FileChannel chl = openFile(false);
        if (chl == null) {
            return null;
        }
        try {
            ByteBuffer buf = ByteBuffer.allocate(128);
            int size = chl.read(buf);
            if (size == 0) {
                return null;
            }
            String line = new String(buf.array(), 0, size, "utf-8");
            return Long.parseLong(line);
        } catch (UnsupportedEncodingException e) {
            // ignore
        } catch (IOException e) {
            throw new RuntimeException(e);
        } finally {
            safeCloseFile(chl);
        }
        return null;
    }

    /**
     * 打开本地文件
     * 
     * @param isWrite 指定是否是写文件
     * @return
     */
    private FileChannel openFile(boolean isWrite) {
        File file = new File(getFullFile());
        FileChannel chl = null;
        try {
            if (!isWrite) {
                chl = new FileInputStream(file).getChannel();
            } else {
                chl = new FileOutputStream(file).getChannel();
            }
        } catch (FileNotFoundException e) {
            if (isWrite) {
                throw new RuntimeException(e);
            }
        }
        return chl;
    }

    /**
     * 安全的关闭打开的文件，隐藏异常处理细节
     * 
     * @param chl
     */
    private void safeCloseFile(FileChannel chl) {
        try {
            if (chl != null) {
                chl.close();
            }
        } catch (IOException e) {
            // ignore
        }
    }

    /**
     * 组装存储文件的全名称
     * 
     * @return
     */
    private String getFullFile() {
        return rootPath + "/" + fileName;
    }
}
