/*
 * Copyright (C) 2016 Baidu, Inc. All Rights Reserved.
 */
package com.baidu.bigpipe.position.store;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.baidu.driver4j.bdrp.client.BdrpClient;

/**
 * 以redis为存储媒体的订阅点存储器实现
 * <p/>
 * key的格式是:pipelet#machineIp##port
 *
 * @author liangxiaojie
 */
public class RedisSubcribePositionStore implements SubcribePositionStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisSubcribePositionStore.class);

    @Autowired
    private BdrpClient bdrpClient;

    public BdrpClient getBdrpClient() {
        return bdrpClient;
    }

    public void setBdrpClient(BdrpClient bdrpClient) {
        this.bdrpClient = bdrpClient;
    }

    private String key;

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    private int expireSeconds;

    public int getExpireSeconds() {
        return expireSeconds;
    }

    public void setExpireSeconds(int expireSeconds) {
        this.expireSeconds = expireSeconds;
    }

    @Override
    public void store(long position) {
        if (key == null || key.length() == 0) {
            LOGGER.error("redis key is null");
            throw new NullPointerException("redis key is null");
        }
        bdrpClient.set(key, String.valueOf(position));
        if (expireSeconds > 0) {
            bdrpClient.expire(key, expireSeconds);
        }
    }

    @Override
    public Long loadPosition() {
        try {
            String line = bdrpClient.get(key);
            return Long.parseLong(line);
        } catch (Exception e) {
            LOGGER.warn("loadPosition fail", e);
        }
        return null;

    }

}
