package com.baidu.bigpipe.protocol;

import java.util.List;

import com.baidu.bigpipe.driver.converter.pub.MessageConverter;

/**
 * bigpipe c-api协议打包消息的构造器。 按照c-api协议进行消息打包，当加入的消息总量 超过2m时，不能再打包任何消息
 * 
 * <pre>
 * change log by xiemalin:
 * 1. chnage mehtod <code>add(Object message);</code> to <code>add(byte[] message);</code>
 * 2. add new method <code> add(MessageConverter messageConverter):</code>
 * 3. remove build method due to it unused
 * </pre>
 * 
 * @author hexiufeng
 * @author xiemalin
 */
public interface BigpipePackBuilder {
	
	/**
	 * 向包中试图加入一条消息，如果包容量足够，能够加入则返回true，否则false
	 * 
	 * @param message
	 *            byte array message
	 * @return true for success
	 */
	boolean add(byte[] message);

	/**
	 * 向包中试图加入一条消息，如果包容量足够，能够加入则返回true，否则false
	 * 
	 * @param message 消息对象
	 * @param messageConverter
	 *            {@link MessageConverter} instance
	 * @return true for success
	 */
	boolean add(Object message, MessageConverter messageConverter);
	
	/**
	 * @return 消息对象byte数组
	 */
	byte[] toByteArray();

	/**
	 * 清零，支持多次重用
	 */
	void reset();

	/**
	 * 是否已经加入消息
	 * 
	 * @return
	 */
	boolean hasMessages();

	/**
	 * 获取放入包内的原始的消息
	 * 
	 * @return
	 */
	List<byte[]> getPackedMessage();
}
