/*
 * Copyright 2015 the original author or authors.
 *
 * Licensed under the BAIDU
 */
package com.baidu.bigpipe.protocol;

/**
 * A fixed string text for each session id create
 * @author xiemalin
 *
 */
public class FixedStringSessionIdProvider implements SessionIdProvider, Cloneable {
	
    private volatile String currentSessionId;
    
    /**
	 * setter method for property currentSessionId
	 * @param currentSessionId the currentSessionId to set
	 */
	public void setCurrentSessionId(String currentSessionId) {
		this.currentSessionId = currentSessionId;
	}
	
	/**
	 * 
	 */
	public FixedStringSessionIdProvider() {
		super();
	}

	/**
	 * @param currentSessionId
	 */
	public FixedStringSessionIdProvider(String currentSessionId) {
		super();
		this.currentSessionId = currentSessionId;
	}

	/* (non-Javadoc)
	 * @see com.baidu.bigpipe.protocol.SessionIdProvider#getSessionId(boolean)
	 */
	@Override
	public String getSessionId(boolean refresh) {
		return currentSessionId;
	}

}
