package com.baidu.bigpipe.protocol;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.zip.Adler32;

import com.baidu.gson.Gson;
import com.baidu.mcpack.Mcpack;
import com.baidu.mcpack.McpackException;

public class McpackCommand {
    public static final int NSHEAD_MAGICNUM = 0xfb709394;
    public static String encoding = Charset.defaultCharset().name();

    /**
     * 向queue server请求订阅数据
     */
    public static final int REQ_QUEUE_DATA = 1;
    /**
     * 向queueserver应答已接收到的数据，真实应答，告知server推动真实数据
     */
    public static final int ACK_QUEUE_TRUE_DATA = 2;
    /**
     * 向queueserver应答已接收到的数据，虚假应答，告知server端推送虚假数据
     */
    public static final int ACK_QUEUE_FAKE_DATA = 3;

    /**
     * 将nshead协议的body部分反序列化为对应的高层mcpack的协议的对象
     * @param buffer body部分的二进制数据
     * @param classOfT 指定二进制数据所对应的搞成协议类型
     * @return 指定的协议类的对象
     * @throws McpackException
     */
    public static <T> T bufferToProtocol(
            ByteBuffer buffer, Class<T> classOfT)
            throws McpackException {
        Gson gson = new Gson();
        Mcpack pack = new Mcpack();
        return gson.fromJson(
                pack.toJsonElement(encoding, buffer.array()), classOfT);
    }

    /**
     * 将高层协议附上nshead头部打包成二进制流
     * @param cmd 基于mcpack的协议头部
     * @return 用于socket channel的二进制流
     */
    public static ByteBuffer protocolToBuffer(McpackCommand cmd)
            throws McpackException {
        Gson gson = new Gson();
        Mcpack pack = new Mcpack();
        byte[] bytes = pack.toMcpack(encoding, gson.toJsonTree(cmd));

        int bodylen = bytes.length;
        ByteBuffer buffer = ByteBuffer.allocate(Nshead.HEAD_SIZE + bodylen);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.position(Nshead.HEAD_SIZE);
        buffer.put(bytes);

        Adler32 checksum = new Adler32();
        checksum.update(buffer.array(), Nshead.HEAD_SIZE, bodylen);

        Nshead head = new Nshead("QueueClient");
        head.setMagicNumber(NSHEAD_MAGICNUM);
        head.setBodyLength(bodylen);
        head.setReserved((int) (checksum.getValue() & 0xffffffff));
        buffer.position(0);
        head.fillBuffer(buffer);
        buffer.position(0);
        return buffer;
    }
}
