package com.baidu.bigpipe.protocol;

import java.nio.ByteBuffer;
import java.util.Arrays;

import com.baidu.bigpipe.tool.BinaryTool;

public class Nshead {
    public static final int HEAD_SIZE = 36;
    public static final int BIGPIPE_MAGIC_NUM = 19902010;

    private short id = 0;
    private short version = 2;
    private int logId = 0;
    private String provider;
    private int magicNumber = BIGPIPE_MAGIC_NUM;
    private int reserved = 0;
    private int bodyLength = 0;

    public static Nshead fromBytes(byte[] bytes) {
        return fromBytes(bytes, BIGPIPE_MAGIC_NUM);
    }

    public static Nshead fromBytes(byte[] bytes, int magicNumber) {
        if (bytes.length < 36)
            throw new RuntimeException("at least 36 bytes for nshead");
        Nshead result = new Nshead("");
        result.id = BinaryTool.calcBufferToShort(bytes, 0);
        result.version = BinaryTool.calcBufferToShort(bytes, 2);
        result.logId = BinaryTool.calcBufferToInteger(bytes, 4);
        int strlen = 0;
        for (int i = 8; i < 24 && bytes[i] != 0; ++i) {
            ++strlen;
        }
        result.provider = new String(bytes, 8, strlen);
        result.magicNumber = BinaryTool.calcBufferToInteger(bytes, 24);
        result.reserved = BinaryTool.calcBufferToInteger(bytes, 28);
        result.bodyLength = BinaryTool.calcBufferToInteger(bytes, 32);

        if (result.magicNumber != magicNumber)
            throw new RuntimeException("wrong magic num for nshead");
        return result;
    }

    public Nshead(String provider) {
        this.provider = provider;
    }

    public short getId() {
        return id;
    }
    public void setId(short id) {
        this.id = id;
    }
    public short getVersion() {
        return version;
    }
    public void setVersion(short version) {
        this.version = version;
    }
    public int getLogId() {
        return logId;
    }
    public void setLogId(int logId) {
        this.logId = logId;
    }
    public String getProvider() {
        return provider;
    }
    public void setProvider(String provider) {
        this.provider = provider;
    }
    public int getMagicNumber() {
        return magicNumber;
    }
    public void setMagicNumber(int magicNumber) {
        this.magicNumber = magicNumber;
    }
    public int getReserved() {
        return reserved;
    }
    public void setReserved(int reserved) {
        this.reserved = reserved;
    }
    public int getBodyLength() {
        return bodyLength;
    }
    public void setBodyLength(int bodylen) {
        this.bodyLength = bodylen;
    }
    public void fillBuffer(ByteBuffer buffer) {
        buffer.putShort(id);
        buffer.putShort(version);
        buffer.putInt(logId);
        int len = provider.length() > 15 ? 15 : provider.length();
        byte[] filler = new byte[16 - len];
        Arrays.fill(filler, (byte) 0);
        buffer.put(provider.getBytes(), 0, len);
        buffer.put(filler);
        buffer.putInt(magicNumber);
        buffer.putInt(reserved);
        buffer.putInt(bodyLength);
    }
    public byte[] getBytes() {
        byte[] buffer = new byte[HEAD_SIZE];
        BinaryTool.copyShortToBuffer(id, buffer,  0);
        BinaryTool.copyShortToBuffer(version, buffer,  2);
        BinaryTool.copyIntegerToBuffer(logId, buffer, 4);
        int len = provider.length() > 15 ? 15 : provider.length();
        System.arraycopy(provider.getBytes(), 0, buffer, 8, len);
        for (int i = len; i < 16; ++i) {
            buffer[8 + i] = 0;
        }
        BinaryTool.copyIntegerToBuffer(magicNumber, buffer, 24);
        BinaryTool.copyIntegerToBuffer(reserved, buffer, 28);
        BinaryTool.copyIntegerToBuffer(bodyLength, buffer, 32);
        return buffer;
    }
}
